/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.jena.atlas.lib.ListUtils;
import org.apache.jena.atlas.lib.SetUtils;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.iri.IRI;
import org.apache.jena.rdf.model.impl.Util;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.nodevalue.NodeFunctions;
import org.apache.jena.sparql.util.EqualityTest;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;

public class NodeUtils {
    public static EqualityTest sameNode = (n1, n2) -> Objects.equals(n1, n2);
    public static EqualityTest sameRdfTerm = (n1, n2) -> NodeFunctions.sameTerm(n1, n2);
    public static EqualityTest sameValue = (n1, n2) -> {
        if (Objects.equals(n1, n2)) {
            return true;
        }
        if (!n1.isLiteral() || !n2.isLiteral()) {
            return false;
        }
        NodeValue nv1 = NodeValue.makeNode(n1);
        NodeValue nv2 = NodeValue.makeNode(n2);
        try {
            return NodeValue.sameAs(nv1, nv2);
        }
        catch (ExprEvalException ex) {
            return false;
        }
    };
    static Set<RDFDatatype> numericDatatypes = new HashSet<RDFDatatype>();

    public static Node asNode(IRI iri) {
        return NodeFactory.createURI((String)iri.toString());
    }

    public static Node asNode(String iri) {
        return NodeFactory.createURI((String)iri);
    }

    public static boolean hasLang(Node node) {
        if (!node.isLiteral()) {
            return false;
        }
        String x = node.getLiteralLanguage();
        if (x == null) {
            return false;
        }
        return !x.equals("");
    }

    public static String stringLiteral(Node literal) {
        if (!literal.isLiteral()) {
            return null;
        }
        RDFDatatype dType = literal.getLiteralDatatype();
        String langTag = literal.getLiteralLanguage();
        if (langTag != null && !langTag.equals("")) {
            return literal.getLiteralLexicalForm();
        }
        if (dType == null || dType.equals(XSDDatatype.XSDstring)) {
            return literal.getLiteralLexicalForm();
        }
        return null;
    }

    public static Iterator<String> nodesToURIs(Iterator<Node> iter) {
        ExtendedIterator eIter = WrappedIterator.create(iter);
        ExtendedIterator conv = eIter.filterKeep(Node::isURI).mapWith(Node::getURI);
        return conv;
    }

    public static Set<Node> convertToSetNodes(Collection<String> namedGraphs) {
        Set nodes = SetUtils.toSet(namedGraphs.stream().map(NodeFactory::createURI));
        return nodes;
    }

    public static Set<Node> convertToSetNodes(String ... namedGraphs) {
        return NodeUtils.convertToSetNodes(Arrays.asList(namedGraphs));
    }

    public static List<Node> convertToListNodes(String ... namedGraphs) {
        return NodeUtils.convertToListNodes(Arrays.asList(namedGraphs));
    }

    public static List<Node> convertToListNodes(List<String> namedGraphs) {
        List nodes = ListUtils.toList(namedGraphs.stream().map(NodeFactory::createURI));
        return nodes;
    }

    public static int compareRDFTerms(Node node1, Node node2) {
        if (node1 == null) {
            if (node2 == null) {
                return 0;
            }
            return -1;
        }
        if (node2 == null) {
            return 1;
        }
        if (node1.isLiteral() && node2.isLiteral()) {
            return NodeUtils.compareLiteralsBySyntax(node1, node2);
        }
        if (node1.isVariable()) {
            if (node2.isVariable()) {
                return StrUtils.strCompare((String)node1.getName(), (String)node2.getName());
            }
            return -1;
        }
        if (node2.isVariable()) {
            return 1;
        }
        if (node1.isBlank()) {
            if (node2.isBlank()) {
                String s1 = node1.getBlankNodeId().getLabelString();
                String s2 = node2.getBlankNodeId().getLabelString();
                return StrUtils.strCompare((String)s1, (String)s2);
            }
            return -1;
        }
        if (node2.isBlank()) {
            return 1;
        }
        if (node1.isURI()) {
            if (node2.isURI()) {
                String s1 = node1.getURI();
                String s2 = node2.getURI();
                return StrUtils.strCompare((String)s1, (String)s2);
            }
            return -1;
        }
        if (node2.isURI()) {
            return 1;
        }
        if (node2.isLiteral()) {
            return 1;
        }
        if (node1.isLiteral()) {
            return -1;
        }
        if (node1.isNodeTriple() && node2.isNodeTriple()) {
            Triple t1 = node1.getTriple();
            Triple t2 = node2.getTriple();
            int x1 = NodeUtils.compareRDFTerms(t1.getSubject(), t2.getSubject());
            if (x1 != 0) {
                return x1;
            }
            int x2 = NodeUtils.compareRDFTerms(t1.getPredicate(), t2.getPredicate());
            if (x2 != 0) {
                return x2;
            }
            int x3 = NodeUtils.compareRDFTerms(t1.getObject(), t2.getObject());
            if (x3 != 0) {
                return x3;
            }
            return 0;
        }
        if (node2.isNodeTriple()) {
            return 1;
        }
        throw new ARQInternalErrorException("Compare: " + node1 + "  " + node2);
    }

    private static int compareLiteralsBySyntax(Node node1, Node node2) {
        String lex2;
        if (node1 == null || !node1.isLiteral() || node2 == null || !node2.isLiteral()) {
            throw new ARQInternalErrorException("compareLiteralsBySyntax called with non-literal: (" + node1 + "," + node2 + ")");
        }
        if (node1.equals((Object)node2)) {
            return 0;
        }
        String lex1 = node1.getLiteralLexicalForm();
        int x = StrUtils.strCompare((String)lex1, (String)(lex2 = node2.getLiteralLexicalForm()));
        if (x != 0) {
            return x;
        }
        if (NodeUtils.isSimpleString(node1)) {
            return -1;
        }
        if (NodeUtils.isSimpleString(node2)) {
            return 1;
        }
        if (NodeUtils.isLangString(node1) && NodeUtils.isLangString(node2)) {
            String lang2;
            String lang1 = node1.getLiteralLanguage();
            x = StrUtils.strCompareIgnoreCase((String)lang1, (String)(lang2 = node2.getLiteralLanguage()));
            if (x != 0) {
                return x;
            }
            x = StrUtils.strCompare((String)lang1, (String)lang2);
            if (x != 0) {
                return x;
            }
            throw new ARQInternalErrorException("compareLiteralsBySyntax: lexical form and languages tags identical on non.equals literals");
        }
        if (NodeUtils.isLangString(node1)) {
            return -1;
        }
        if (NodeUtils.isLangString(node2)) {
            return 1;
        }
        String dt1 = node1.getLiteralDatatypeURI();
        String dt2 = node2.getLiteralDatatypeURI();
        return StrUtils.strCompare((String)dt1, (String)dt2);
    }

    public static boolean isSimpleString(Node n) {
        return Util.isSimpleString((Node)n);
    }

    public static boolean isLangString(Node n) {
        return Util.isLangString((Node)n);
    }

    public static boolean isXSDNumeric(Node node) {
        if (!node.isLiteral()) {
            return false;
        }
        return numericDatatypes.contains(node.getLiteralDatatype());
    }

    static {
        numericDatatypes.add((RDFDatatype)XSDDatatype.XSDdecimal);
        numericDatatypes.add((RDFDatatype)XSDDatatype.XSDinteger);
        numericDatatypes.add((RDFDatatype)XSDDatatype.XSDlong);
        numericDatatypes.add((RDFDatatype)XSDDatatype.XSDint);
        numericDatatypes.add((RDFDatatype)XSDDatatype.XSDshort);
        numericDatatypes.add((RDFDatatype)XSDDatatype.XSDbyte);
        numericDatatypes.add((RDFDatatype)XSDDatatype.XSDnonPositiveInteger);
        numericDatatypes.add((RDFDatatype)XSDDatatype.XSDnegativeInteger);
        numericDatatypes.add((RDFDatatype)XSDDatatype.XSDnonNegativeInteger);
        numericDatatypes.add((RDFDatatype)XSDDatatype.XSDpositiveInteger);
        numericDatatypes.add((RDFDatatype)XSDDatatype.XSDunsignedLong);
        numericDatatypes.add((RDFDatatype)XSDDatatype.XSDunsignedInt);
        numericDatatypes.add((RDFDatatype)XSDDatatype.XSDunsignedShort);
        numericDatatypes.add((RDFDatatype)XSDDatatype.XSDdouble);
        numericDatatypes.add((RDFDatatype)XSDDatatype.XSDfloat);
    }
}

