/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.jenax.progress;

import org.topbraid.jenax.progress.ProgressMonitor;

public class SimpleProgressMonitor
implements ProgressMonitor {
    private volatile boolean canceled;
    private int currentWork;
    private String name;
    private int totalWork;

    public SimpleProgressMonitor(String name) {
        this.name = name;
    }

    @Override
    public void beginTask(String label, int totalWork) {
        this.println("Beginning task " + label + " (" + totalWork + ")");
        this.totalWork = totalWork;
        this.currentWork = 0;
    }

    @Override
    public void done() {
        this.println("Done");
    }

    @Override
    public boolean isCanceled() {
        return this.canceled;
    }

    protected void println(String text) {
        System.out.println(this.name + ": " + text);
    }

    @Override
    public void setCanceled(boolean value) {
        this.canceled = value;
    }

    @Override
    public void setTaskName(String value) {
        this.println("Task name: " + value);
    }

    @Override
    public void subTask(String label) {
        this.println("Subtask: " + label);
    }

    @Override
    public void worked(int amount) {
        this.currentWork += amount;
        this.println("Worked " + this.currentWork + " / " + this.totalWork);
    }
}

