/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.jenax.functions;

import java.util.Iterator;
import org.apache.jena.query.ARQ;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.sparql.function.FunctionFactory;
import org.apache.jena.sparql.function.FunctionRegistry;
import org.apache.jena.sparql.util.Context;
import org.topbraid.jenax.functions.CurrentThreadFunctions;

public class CurrentThreadFunctionRegistry
extends FunctionRegistry {
    private static ThreadLocal<CurrentThreadFunctions> localFunctions = new ThreadLocal();
    private static CurrentThreadFunctionRegistry singleton = new CurrentThreadFunctionRegistry(FunctionRegistry.get());
    private FunctionRegistry base;

    public static CurrentThreadFunctionRegistry get() {
        return singleton;
    }

    public static Runnable register(Model model) {
        CurrentThreadFunctions old = localFunctions.get();
        CurrentThreadFunctions neo = new CurrentThreadFunctions(model);
        localFunctions.set(neo);
        FunctionRegistry oldFR = FunctionRegistry.get();
        if (oldFR != singleton) {
            FunctionRegistry.set((Context)ARQ.getContext(), (FunctionRegistry)singleton);
            return () -> {
                CurrentThreadFunctionRegistry.unregister(old);
                FunctionRegistry.set((Context)ARQ.getContext(), (FunctionRegistry)oldFR);
            };
        }
        return () -> CurrentThreadFunctionRegistry.unregister(old);
    }

    private static void unregister(CurrentThreadFunctions old) {
        if (old != null) {
            localFunctions.set(old);
        } else {
            localFunctions.remove();
        }
    }

    public static CurrentThreadFunctions getFunctions() {
        return localFunctions.get();
    }

    private CurrentThreadFunctionRegistry(FunctionRegistry base) {
        this.base = base;
    }

    public FunctionFactory get(String uri) {
        FunctionFactory ff;
        FunctionFactory b = this.base.get(uri);
        if (b != null) {
            return b;
        }
        CurrentThreadFunctions functions = localFunctions.get();
        if (functions != null && (ff = functions.getFunctionFactory(uri)) != null) {
            return ff;
        }
        return null;
    }

    public boolean isRegistered(String uri) {
        if (this.base.isRegistered(uri)) {
            return true;
        }
        return this.get(uri) != null;
    }

    public Iterator<String> keys() {
        return this.base.keys();
    }

    public void put(String uri, Class<?> funcClass) {
        this.base.put(uri, funcClass);
    }

    public void put(String uri, FunctionFactory f) {
        this.base.put(uri, f);
    }

    public FunctionFactory remove(String uri) {
        return this.base.remove(uri);
    }
}

