/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.arq.functions;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionEnv;
import org.topbraid.jenax.functions.AbstractFunction1;

public class CheckRegexSyntaxFunction
extends AbstractFunction1 {
    @Override
    protected NodeValue exec(Node regexNode, FunctionEnv env) {
        if (regexNode == null || !regexNode.isLiteral()) {
            return NodeValue.makeString((String)("Invalid argument to spif:checkRegexSyntax: " + regexNode));
        }
        String str = regexNode.getLiteralLexicalForm();
        try {
            Pattern.compile(str);
        }
        catch (Exception ex) {
            String message = ex instanceof PatternSyntaxException ? this.buildSystemIndependentMessage((PatternSyntaxException)ex) : ex.getMessage();
            return NodeValue.makeString((String)message);
        }
        throw new ExprEvalException();
    }

    private String buildSystemIndependentMessage(PatternSyntaxException ex) {
        Object message = ex.getMessage();
        if (!System.lineSeparator().contains("\r")) {
            return message;
        }
        message = ((String)message).replaceFirst("\r", "");
        int index = ex.getIndex();
        String pattern = ex.getPattern();
        if (index >= 0 && pattern != null && index < pattern.length()) {
            int last = ((String)message).lastIndexOf("\r");
            message = ((String)message).substring(0, last) + ((String)message).substring(last + 1);
        }
        return message;
    }
}

