/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.engine;

import java.net.URI;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.topbraid.jenax.progress.ProgressMonitor;
import org.topbraid.shacl.engine.SHACLCanceledException;
import org.topbraid.shacl.engine.ShapesGraph;
import org.topbraid.shacl.entailment.SHACLEntailment;
import org.topbraid.shacl.expr.NodeExpressionContext;
import org.topbraid.shacl.validation.DefaultShapesGraphProvider;
import org.topbraid.shacl.vocabulary.SH;

public abstract class AbstractEngine
implements NodeExpressionContext {
    protected Dataset dataset;
    protected ProgressMonitor monitor;
    protected ShapesGraph shapesGraph;
    protected URI shapesGraphURI;
    private Model shapesModel;

    protected AbstractEngine(Dataset dataset, ShapesGraph shapesGraph, URI shapesGraphURI) {
        if (shapesGraphURI == null) {
            shapesGraphURI = DefaultShapesGraphProvider.get().getDefaultShapesGraphURI(dataset);
        }
        this.dataset = dataset;
        this.shapesGraph = shapesGraph;
        this.shapesGraphURI = shapesGraphURI;
    }

    public void applyEntailments() throws InterruptedException {
        Model shapesModel = this.dataset.getNamedModel(this.shapesGraphURI.toString());
        for (RDFNode ent : shapesModel.listObjectsOfProperty(SH.entailment).toList()) {
            if (!ent.isURIResource()) continue;
            if (SHACLEntailment.get().getEngine(ent.asResource().getURI()) != null) {
                this.dataset = SHACLEntailment.get().withEntailment(this.dataset, this.shapesGraphURI, this.shapesGraph, ent.asResource(), this.monitor);
                continue;
            }
            throw new UnsupportedOperationException("Unsupported entailment regime " + ent);
        }
    }

    public void checkCanceled() {
        if (this.monitor != null && this.monitor.isCanceled()) {
            throw new SHACLCanceledException();
        }
    }

    @Override
    public Dataset getDataset() {
        return this.dataset;
    }

    public ProgressMonitor getProgressMonitor() {
        return this.monitor;
    }

    @Override
    public ShapesGraph getShapesGraph() {
        return this.shapesGraph;
    }

    @Override
    public URI getShapesGraphURI() {
        return this.shapesGraphURI;
    }

    public Model getShapesModel() {
        if (this.shapesModel == null) {
            this.shapesModel = this.dataset.getNamedModel(this.shapesGraphURI.toString());
        }
        return this.shapesModel;
    }

    public void setProgressMonitor(ProgressMonitor value) {
        this.monitor = value;
    }
}

