/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.sparql.path.P_Inverse;
import org.apache.jena.sparql.path.P_Link;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.vocabulary.RDFS;
import org.topbraid.jenax.util.JenaUtil;
import org.topbraid.jenax.util.RDFLabels;
import org.topbraid.shacl.arq.SHACLPaths;
import org.topbraid.shacl.engine.Constraint;
import org.topbraid.shacl.engine.ShapesGraph;
import org.topbraid.shacl.model.SHConstraintComponent;
import org.topbraid.shacl.model.SHFactory;
import org.topbraid.shacl.model.SHParameter;
import org.topbraid.shacl.model.SHParameterizableTarget;
import org.topbraid.shacl.model.SHShape;
import org.topbraid.shacl.targets.CustomTargetLanguage;
import org.topbraid.shacl.targets.CustomTargets;
import org.topbraid.shacl.targets.InstancesTarget;
import org.topbraid.shacl.targets.NodeTarget;
import org.topbraid.shacl.targets.ObjectsOfTarget;
import org.topbraid.shacl.targets.SubjectsOfTarget;
import org.topbraid.shacl.targets.Target;
import org.topbraid.shacl.vocabulary.SH;

public class Shape {
    private List<Constraint> constraints;
    private boolean deactivated;
    private Path jenaPath;
    private Resource path;
    private Property predicate;
    private List<RDFNode> messages;
    private boolean nodeShape;
    private Resource severity;
    private SHShape shape;
    private ShapesGraph shapesGraph;
    private List<Target> targets = new ArrayList<Target>();

    public Shape(ShapesGraph shapesGraph, SHShape shape) {
        this.shape = shape;
        this.shapesGraph = shapesGraph;
        this.deactivated = shape.isDeactivated();
        this.severity = shape.getSeverity();
        Resource path = shape.getPath();
        if (path != null) {
            this.path = path;
            if (path.isAnon()) {
                this.jenaPath = (Path)SHACLPaths.getJenaPath(SHACLPaths.getPathString(path), path.getModel());
            } else {
                this.predicate = JenaUtil.asProperty(path);
            }
        } else {
            this.nodeShape = true;
        }
        this.collectTargets();
    }

    private void collectTargets() {
        if (JenaUtil.hasIndirectType(this.shape, RDFS.Class)) {
            this.targets.add(new InstancesTarget(this.shape));
        }
        for (Resource targetClass : JenaUtil.getResourceProperties(this.shape, SH.targetClass)) {
            this.targets.add(new InstancesTarget(targetClass));
        }
        for (RDFNode targetNode : this.shape.getModel().listObjectsOfProperty((Resource)this.shape, SH.targetNode).toList()) {
            this.targets.add(new NodeTarget(targetNode));
        }
        for (Resource sof : JenaUtil.getResourceProperties(this.shape, SH.targetSubjectsOf)) {
            this.targets.add(new SubjectsOfTarget(JenaUtil.asProperty(sof)));
        }
        for (Resource sof : JenaUtil.getResourceProperties(this.shape, SH.targetObjectsOf)) {
            this.targets.add(new ObjectsOfTarget(JenaUtil.asProperty(sof)));
        }
        Iterator<Object> iterator = JenaUtil.getResourceProperties(this.shape, SH.target).iterator();
        while (iterator.hasNext()) {
            Resource target;
            Resource executable = target = (Resource)iterator.next();
            SHParameterizableTarget parameterizableTarget = null;
            if (SHFactory.isParameterizableInstance((RDFNode)target)) {
                parameterizableTarget = SHFactory.asParameterizableTarget((RDFNode)target);
                executable = parameterizableTarget.getParameterizable();
            }
            CustomTargetLanguage language = CustomTargets.get().getLanguageForTarget(executable);
            Target t = language.createTarget(executable, parameterizableTarget);
            this.targets.add(t);
        }
    }

    public synchronized Iterable<Constraint> getConstraints() {
        if (this.constraints == null) {
            this.constraints = new LinkedList<Constraint>();
            HashSet<SHConstraintComponent> handled = new HashSet<SHConstraintComponent>();
            for (Statement s : this.shape.listProperties().toList()) {
                Constraint constraint;
                SHConstraintComponent component = this.shapesGraph.getComponentWithParameter(s.getPredicate());
                if (component == null || handled.contains(component)) continue;
                List<SHParameter> params = component.getParameters();
                if (params.size() == 1) {
                    constraint = this.shapesGraph.createConstraint(this, component, params, s.getObject());
                    if (this.shapesGraph.isIgnoredConstraint(constraint)) continue;
                    this.constraints.add(constraint);
                    continue;
                }
                if (!this.isComplete(params)) continue;
                handled.add(component);
                constraint = this.shapesGraph.createConstraint(this, component, params, null);
                if (this.shapesGraph.isIgnoredConstraint(constraint)) continue;
                this.constraints.add(constraint);
            }
        }
        return this.constraints;
    }

    public Property getInversePredicate() {
        if (this.jenaPath instanceof P_Inverse && ((P_Inverse)this.jenaPath).getSubPath() instanceof P_Link) {
            return ResourceFactory.createProperty((String)((P_Link)((P_Inverse)this.jenaPath).getSubPath()).getNode().getURI());
        }
        return null;
    }

    public Path getJenaPath() {
        return this.jenaPath;
    }

    public synchronized Collection<RDFNode> getMessages() {
        if (this.messages == null) {
            this.messages = this.shape.listProperties(SH.message).mapWith(s -> s.getObject()).toList();
        }
        return this.messages;
    }

    public Double getOrder() {
        Statement s = this.shape.getProperty(SH.order);
        if (s != null && s.getObject().isLiteral()) {
            return s.getLiteral().getDouble();
        }
        return 0.0;
    }

    public Resource getPath() {
        return this.path;
    }

    public Property getPredicate() {
        return this.predicate;
    }

    public Resource getSeverity() {
        return this.severity;
    }

    public SHShape getShapeResource() {
        return this.shape;
    }

    public ShapesGraph getShapesGraph() {
        return this.shapesGraph;
    }

    public Set<RDFNode> getTargetNodes(Dataset dataset) {
        HashSet<RDFNode> results = new HashSet<RDFNode>();
        for (Target target : this.targets) {
            target.addTargetNodes(dataset, results);
        }
        return results;
    }

    public List<Target> getTargets() {
        return this.targets;
    }

    private boolean isComplete(List<SHParameter> params) {
        for (SHParameter param : params) {
            if (param.isOptional() || this.shape.hasProperty(param.getPredicate())) continue;
            return false;
        }
        return true;
    }

    public boolean isDeactivated() {
        return this.deactivated;
    }

    public boolean isNodeShape() {
        return this.nodeShape;
    }

    public String toString() {
        return RDFLabels.get().getLabel(this.getShapeResource());
    }
}

