/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.engine;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.graph.PrefixMappingMem;
import org.apache.jena.sparql.util.FmtUtils;
import org.apache.jena.vocabulary.RDFS;
import org.topbraid.jenax.util.JenaDatatypes;
import org.topbraid.jenax.util.JenaUtil;
import org.topbraid.shacl.arq.SHACLPaths;
import org.topbraid.shacl.engine.Constraint;
import org.topbraid.shacl.engine.Shape;
import org.topbraid.shacl.expr.NodeExpression;
import org.topbraid.shacl.expr.NodeExpressionFactory;
import org.topbraid.shacl.expr.lib.DistinctExpression;
import org.topbraid.shacl.expr.lib.UnionExpression;
import org.topbraid.shacl.model.SHConstraintComponent;
import org.topbraid.shacl.model.SHFactory;
import org.topbraid.shacl.model.SHParameter;
import org.topbraid.shacl.model.SHShape;
import org.topbraid.shacl.vocabulary.DASH;
import org.topbraid.shacl.vocabulary.SH;

public class ShapesGraph {
    private static final Map<Node, NodeExpression> EMPTY = new HashMap<Node, NodeExpression>();
    private Predicate<Constraint> constraintFilter;
    private Map<Node, Map<Node, NodeExpression>> defaultValueMap = new ConcurrentHashMap<Node, Map<Node, NodeExpression>>();
    private PrefixMapping fastPrefixMapping;
    private Map<Node, Boolean> ignoredShapes = new ConcurrentHashMap<Node, Boolean>();
    private Map<Property, SHConstraintComponent> parametersMap = new ConcurrentHashMap<Property, SHConstraintComponent>();
    private List<Shape> rootShapes;
    private Predicate<SHShape> shapeFilter;
    private Map<Node, Shape> shapesMap = new ConcurrentHashMap<Node, Shape>();
    private Model shapesModel;
    private Map<Node, Map<Node, NodeExpression>> valuesMap = new ConcurrentHashMap<Node, Map<Node, NodeExpression>>();

    public ShapesGraph(Model shapesModel) {
        this.shapesModel = shapesModel;
    }

    public ShapesGraph clone() {
        ShapesGraph clone = new ShapesGraph(this.shapesModel);
        clone.constraintFilter = this.constraintFilter;
        clone.shapeFilter = this.shapeFilter;
        return clone;
    }

    public Constraint createConstraint(Shape shape, SHConstraintComponent component, List<SHParameter> params, RDFNode parameterValue) {
        return new Constraint(shape, component, params, parameterValue);
    }

    public SHConstraintComponent getComponentWithParameter(Property parameter) {
        return this.parametersMap.computeIfAbsent(parameter, p -> {
            StmtIterator it = this.shapesModel.listStatements(null, SH.path, (RDFNode)parameter);
            while (it.hasNext()) {
                Resource param = ((Statement)it.next()).getSubject();
                if (param.hasProperty(SH.optional, (RDFNode)JenaDatatypes.TRUE)) continue;
                StmtIterator i2 = this.shapesModel.listStatements(null, SH.parameter, (RDFNode)param);
                while (i2.hasNext()) {
                    Resource r = ((Statement)i2.next()).getSubject();
                    if (!JenaUtil.hasIndirectType(r, SH.ConstraintComponent)) continue;
                    i2.close();
                    it.close();
                    SHConstraintComponent cc = SHFactory.asConstraintComponent((RDFNode)r);
                    return cc;
                }
            }
            return null;
        });
    }

    public synchronized PrefixMapping getFastPrefixMapping() {
        if (this.fastPrefixMapping == null) {
            this.fastPrefixMapping = new PrefixMappingMem();
            Map pm = this.shapesModel.getNsPrefixMap();
            for (String prefix : pm.keySet()) {
                this.fastPrefixMapping.setNsPrefix(prefix, (String)pm.get(prefix));
            }
        }
        return this.fastPrefixMapping;
    }

    public String getPathString(Resource path) {
        if (path.isURIResource()) {
            return FmtUtils.stringForNode((Node)path.asNode(), (PrefixMapping)this.getFastPrefixMapping());
        }
        return SHACLPaths.getPathString(path);
    }

    public synchronized List<Shape> getRootShapes() {
        if (this.rootShapes == null) {
            HashSet<Resource> candidates = new HashSet<Resource>();
            candidates.addAll(this.shapesModel.listSubjectsWithProperty(SH.target).toList());
            candidates.addAll(this.shapesModel.listSubjectsWithProperty(SH.targetClass).toList());
            candidates.addAll(this.shapesModel.listSubjectsWithProperty(SH.targetNode).toList());
            candidates.addAll(this.shapesModel.listSubjectsWithProperty(SH.targetObjectsOf).toList());
            candidates.addAll(this.shapesModel.listSubjectsWithProperty(SH.targetSubjectsOf).toList());
            for (Resource shape : JenaUtil.getAllInstances(this.shapesModel.getResource(SH.NodeShape.getURI()))) {
                if (!JenaUtil.hasIndirectType(shape, RDFS.Class)) continue;
                candidates.add(shape);
            }
            for (Resource shape : JenaUtil.getAllInstances(this.shapesModel.getResource(SH.PropertyShape.getURI()))) {
                if (!JenaUtil.hasIndirectType(shape, RDFS.Class)) continue;
                candidates.add(shape);
            }
            this.rootShapes = new LinkedList<Shape>();
            for (Resource candidate : candidates) {
                SHShape shape = SHFactory.asShape((RDFNode)candidate);
                if (shape.isDeactivated() || this.isIgnored(shape.asNode())) continue;
                this.rootShapes.add(this.getShape(shape.asNode()));
            }
        }
        return this.rootShapes;
    }

    public Shape getShape(Node node) {
        return this.shapesMap.computeIfAbsent(node, n -> new Shape(this, SHFactory.asShape(this.shapesModel.asRDFNode(node))));
    }

    public Map<Node, NodeExpression> getDefaultValueNodeExpressionsMap(Resource predicate) {
        return this.getExpressionsMap(this.defaultValueMap, predicate, SH.defaultValue);
    }

    public Map<Node, NodeExpression> getValuesNodeExpressionsMap(Resource predicate) {
        return this.getExpressionsMap(this.valuesMap, predicate, SH.values);
    }

    private Map<Node, NodeExpression> getExpressionsMap(Map<Node, Map<Node, NodeExpression>> valuesMap, Resource predicate, Property systemPredicate) {
        return valuesMap.computeIfAbsent(predicate.asNode(), p -> {
            HashMap<Node, List<NodeExpression>> map = new HashMap<Node, List<NodeExpression>>();
            StmtIterator it = this.shapesModel.listStatements(null, SH.path, (RDFNode)predicate);
            while (it.hasNext()) {
                Resource ps = ((Statement)it.next()).getSubject();
                if (!ps.hasProperty(systemPredicate) || ps.hasProperty(SH.deactivated, (RDFNode)JenaDatatypes.TRUE)) continue;
                StmtIterator nit = this.shapesModel.listStatements(null, SH.property, (RDFNode)ps);
                while (nit.hasNext()) {
                    Resource nodeShape = ((Statement)nit.next()).getSubject();
                    if (nodeShape.hasProperty(SH.deactivated, (RDFNode)JenaDatatypes.TRUE)) continue;
                    Node shapeNode = nodeShape.asNode();
                    this.addExpressions(map, ps, shapeNode, systemPredicate);
                    for (Resource targetClass : JenaUtil.getResourceProperties(nodeShape, SH.targetClass)) {
                        this.addExpressions(map, ps, targetClass.asNode(), systemPredicate);
                    }
                    for (Resource targetClass : JenaUtil.getResourceProperties(nodeShape, DASH.applicableToClass)) {
                        this.addExpressions(map, ps, targetClass.asNode(), systemPredicate);
                    }
                }
            }
            if (map.isEmpty()) {
                return EMPTY;
            }
            HashMap<Node, NodeExpression> result = new HashMap<Node, NodeExpression>();
            for (Node key : map.keySet()) {
                List list = (List)map.get(key);
                if (list.size() > 1) {
                    RDFNode exprNode = this.shapesModel.asRDFNode(key);
                    result.put(key, new DistinctExpression(exprNode, new UnionExpression(exprNode, list)));
                    continue;
                }
                result.put(key, (NodeExpression)list.get(0));
            }
            return result;
        });
    }

    private void addExpressions(Map<Node, List<NodeExpression>> map, Resource ps, Node shapeNode, Property systemPredicate) {
        map.computeIfAbsent(shapeNode, n -> {
            LinkedList<NodeExpression> exprs = new LinkedList<NodeExpression>();
            StmtIterator vit = ps.listProperties(systemPredicate);
            while (vit.hasNext()) {
                RDFNode expr = ((Statement)vit.next()).getObject();
                NodeExpression nodeExpression = NodeExpressionFactory.get().create(expr);
                exprs.add(nodeExpression);
            }
            return exprs;
        });
    }

    public Model getShapesModel() {
        return this.shapesModel;
    }

    public boolean isIgnored(Node shapeNode) {
        if (this.shapeFilter == null) {
            return false;
        }
        return this.ignoredShapes.computeIfAbsent(shapeNode, node -> {
            SHShape shape = SHFactory.asShape(this.shapesModel.asRDFNode(shapeNode));
            return !this.shapeFilter.test(shape);
        });
    }

    public boolean isIgnoredConstraint(Constraint constraint) {
        return this.constraintFilter != null && !this.constraintFilter.test(constraint);
    }

    public void setConstraintFilter(Predicate<Constraint> value) {
        this.constraintFilter = value;
    }

    public void setShapeFilter(Predicate<SHShape> value) {
        this.shapeFilter = value;
    }
}

