/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.expr.lib;

import java.util.LinkedList;
import java.util.List;
import org.apache.jena.graph.Node;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.ARQConstants;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.binding.BindingBuilder;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.Function;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.function.FunctionFactory;
import org.apache.jena.sparql.function.FunctionRegistry;
import org.apache.jena.sparql.sse.ItemList;
import org.apache.jena.sparql.sse.builders.BuilderExpr;
import org.apache.jena.sparql.sse.builders.ExprBuildException;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.ExprUtils;
import org.apache.jena.sparql.util.FmtUtils;
import org.apache.jena.sparql.util.NodeFactoryExtra;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;
import org.topbraid.jenax.functions.CurrentThreadFunctionRegistry;
import org.topbraid.jenax.functions.OptionalArgsFunction;
import org.topbraid.shacl.expr.ComplexNodeExpression;
import org.topbraid.shacl.expr.NodeExpression;
import org.topbraid.shacl.expr.NodeExpressionContext;
import org.topbraid.shacl.expr.NodeExpressionVisitor;

public class FunctionExpression
extends ComplexNodeExpression {
    private List<NodeExpression> args;
    private Expr expr;
    private Resource function;

    public FunctionExpression(RDFNode expr, Resource function, List<NodeExpression> args) {
        super(expr);
        this.args = args;
        this.function = function;
        if (function.getNameSpace().equals("http://datashapes.org/sparql#")) {
            if (!BuilderExpr.isDefined((String)function.getLocalName())) {
                throw new IllegalArgumentException("Unknown SPARQL built-in " + function.getLocalName());
            }
            ItemList il = new ItemList();
            il.add(function.getLocalName());
            for (int i = 0; i < args.size(); ++i) {
                il.add((Node)Var.alloc((String)("a" + i)));
            }
            try {
                this.expr = BuilderExpr.buildExpr((ItemList)il);
            }
            catch (ExprBuildException ebe) {
                throw new IllegalArgumentException("Failed to build expression for " + il, ebe);
            }
        } else {
            StringBuffer sb = new StringBuffer();
            sb.append("<");
            sb.append(function);
            sb.append(">(");
            for (int i = 0; i < args.size(); ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append("?a" + i);
            }
            sb.append(")");
            this.expr = ExprUtils.parse((String)sb.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExtendedIterator<RDFNode> eval(RDFNode focusNode, NodeExpressionContext context) {
        Function arq;
        LinkedList<RDFNode> results = new LinkedList<RDFNode>();
        Context cxt = ARQ.getContext().copy();
        cxt.set(ARQConstants.sysCurrentTime, (Object)NodeFactoryExtra.nowAsDateTime());
        OptionalArgsFunction opt = null;
        FunctionFactory ff = FunctionRegistry.get().get(this.function.getURI());
        if (ff != null && (arq = ff.create(this.function.getURI())) instanceof OptionalArgsFunction) {
            opt = (OptionalArgsFunction)arq;
        }
        int total = 1;
        LinkedList<List> as = new LinkedList<List>();
        for (int i = 0; i < this.args.size(); ++i) {
            NodeExpression expr = this.args.get(i);
            List a = expr.eval(focusNode, context).toList();
            if (a.isEmpty()) {
                if (opt == null || !opt.isOptionalArg(i)) {
                    return WrappedIterator.create(results.iterator());
                }
            } else {
                total *= a.size();
            }
            as.add(a);
        }
        Runnable tearDownCTFR = CurrentThreadFunctionRegistry.register(context.getShapesGraph().getShapesModel());
        try {
            for (int x = 0; x < total; ++x) {
                int y = x;
                BindingBuilder builder = BindingBuilder.create();
                for (int i = 0; i < this.args.size(); ++i) {
                    List a = (List)as.get(i);
                    if (a.isEmpty()) continue;
                    int m = y % a.size();
                    builder.add(Var.alloc((String)("a" + i)), ((RDFNode)a.get(m)).asNode());
                    y /= a.size();
                }
                Dataset dataset = context.getDataset();
                DatasetGraph dsg = dataset.asDatasetGraph();
                ExecutionContext env = new ExecutionContext(cxt, dsg.getDefaultGraph(), dsg, null);
                try {
                    Model defaultModel;
                    RDFNode rdfNode;
                    NodeValue r = this.expr.eval(builder.build(), (FunctionEnv)env);
                    if (r == null || results.contains(rdfNode = (defaultModel = dataset.getDefaultModel()).asRDFNode(r.asNode()))) continue;
                    results.add(rdfNode);
                    continue;
                }
                catch (ExprEvalException exprEvalException) {
                    // empty catch block
                }
            }
        }
        finally {
            tearDownCTFR.run();
        }
        return WrappedIterator.create(results.iterator());
    }

    public Resource getFunction() {
        return this.function;
    }

    @Override
    public List<String> getFunctionalSyntaxArguments() {
        LinkedList<String> results = new LinkedList<String>();
        results.add(FmtUtils.stringForRDFNode((RDFNode)this.function));
        for (NodeExpression arg : this.args) {
            results.add(arg.getFunctionalSyntax());
        }
        return results;
    }

    @Override
    public List<NodeExpression> getInputExpressions() {
        return this.args;
    }

    @Override
    public String getTypeId() {
        return "function";
    }

    @Override
    public void visit(NodeExpressionVisitor visitor) {
        visitor.visit(this);
    }
}

