/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.multifunctions;

import java.lang.invoke.MethodHandles;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.pfunction.PropertyFunctionFactory;
import org.apache.jena.sparql.pfunction.PropertyFunctionRegistry;
import org.apache.jena.vocabulary.RDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.topbraid.jenax.util.JenaUtil;
import org.topbraid.shacl.multifunctions.AbstractNativeMultiFunction;
import org.topbraid.shacl.multifunctions.MultiFunction;
import org.topbraid.shacl.multifunctions.MultiFunctionPropertyFunction;
import org.topbraid.shacl.multifunctions.SPARQLMultiFunction;
import org.topbraid.shacl.vocabulary.DASH;

public class MultiFunctions {
    static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static Map<String, MultiFunction> map = new ConcurrentHashMap<String, MultiFunction>();

    public static MultiFunction get(String uri) {
        return map.get(uri);
    }

    public static MultiFunction getOrCreate(Resource multiFunction) {
        try {
            return map.computeIfAbsent(multiFunction.getURI(), d -> {
                SPARQLMultiFunction mf = SPARQLMultiFunction.create(multiFunction);
                PropertyFunctionRegistry.get().put(mf.getURI(), (PropertyFunctionFactory)new MultiFunctionPropertyFunction(mf));
                return mf;
            });
        }
        catch (Exception ex) {
            log.error("Failed to install SPARQL property function for multi-function " + multiFunction.getURI(), (Throwable)ex);
            return null;
        }
    }

    public static MultiFunctionPropertyFunction register(MultiFunction multiFunction) {
        map.put(multiFunction.getURI(), multiFunction);
        MultiFunctionPropertyFunction factory = new MultiFunctionPropertyFunction(multiFunction);
        PropertyFunctionRegistry.get().put(multiFunction.getURI(), (PropertyFunctionFactory)factory);
        return factory;
    }

    public static void registerAll(Model model) {
        model.listSubjectsWithProperty(RDF.type, (RDFNode)DASH.SPARQLMultiFunction).forEachRemaining(multiFunction -> {
            if (multiFunction.isURIResource()) {
                try {
                    SPARQLMultiFunction mf = SPARQLMultiFunction.create(multiFunction);
                    MultiFunctions.register(mf);
                }
                catch (Exception ex) {
                    log.error("Failed to install SPARQL property function for multi-function " + multiFunction.getURI(), (Throwable)ex);
                }
            }
        });
        model.listSubjectsWithProperty(RDF.type, (RDFNode)DASH.MultiFunction).forEachRemaining(multiFunction -> {
            MultiFunction mf = MultiFunctions.get(multiFunction.getURI());
            if (mf != null) {
                if (mf instanceof AbstractNativeMultiFunction) {
                    try {
                        ((AbstractNativeMultiFunction)mf).initFrom((Resource)multiFunction);
                    }
                    catch (Exception ex) {
                        log.error("Failed to install native multi-function " + multiFunction.getURI(), (Throwable)ex);
                    }
                }
            } else {
                log.error("UNEXPECTED INIT ORDER REACHED");
            }
        });
    }

    public static Iterable<String> registerAllTemp(Model model) {
        LinkedList<String> newURIs = new LinkedList<String>();
        Resource mfClass = DASH.SPARQLMultiFunction.inModel(model);
        for (Resource multiFunction : JenaUtil.getAllInstances(mfClass)) {
            if (!multiFunction.isURIResource() || MultiFunctions.get(multiFunction.getURI()) != null) continue;
            try {
                SPARQLMultiFunction mf = SPARQLMultiFunction.create(multiFunction);
                MultiFunctions.register(mf);
                newURIs.add(multiFunction.getURI());
            }
            catch (Exception ex) {
                log.error("Failed to install SPARQL property function for multi-function " + multiFunction.getURI(), (Throwable)ex);
            }
        }
        return newURIs;
    }

    public static void unregister(String uri) {
        PropertyFunctionRegistry.get().remove(uri);
        map.remove(uri);
    }

    public static Stream<String> uris() {
        return map.keySet().stream();
    }
}

