/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.multifunctions;

import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import org.apache.jena.sparql.engine.iterator.QueryIteratorWrapper;
import org.topbraid.jenax.util.ARQFactory;
import org.topbraid.jenax.util.DatasetWithDifferentDefaultModel;
import org.topbraid.jenax.util.JenaUtil;
import org.topbraid.shacl.multifunctions.AbstractMultiFunction;
import org.topbraid.shacl.multifunctions.MultiFunctionParameter;
import org.topbraid.shacl.validation.sparql.SPARQLSubstitutions;
import org.topbraid.shacl.vocabulary.SH;

public class SPARQLMultiFunction
extends AbstractMultiFunction {
    private Query query;

    public static SPARQLMultiFunction create(Resource declaration) throws IllegalArgumentException {
        if (declaration.isAnon()) {
            throw new IllegalArgumentException("Declaration must be a URI node");
        }
        String uri = declaration.getURI();
        String queryString = JenaUtil.getStringProperty(declaration, SH.select);
        if (queryString == null) {
            throw new IllegalArgumentException("dash:SPARQLMultiFunction " + declaration + " does not declare a sh:select query");
        }
        Query query = ARQFactory.get().createQuery(SPARQLSubstitutions.withPrefixes(queryString, declaration));
        return new SPARQLMultiFunction(uri, declaration, query);
    }

    private SPARQLMultiFunction(String uri, Resource declaration, Query query) {
        super(uri, declaration);
        this.query = query;
    }

    @Override
    public QueryIterator execute(List<Node> args, Graph activeGraph, DatasetGraph dataset) {
        QuerySolutionMap initialBindings = new QuerySolutionMap();
        if (args.size() > this.getParameters().size()) {
            throw new IllegalArgumentException("Too many arguments for multi-function " + this.getURI() + ": " + args.size() + " >= " + this.getParameters().size());
        }
        if (activeGraph == null) {
            activeGraph = JenaUtil.createDefaultGraph();
        }
        Model model = ModelFactory.createModelForGraph((Graph)activeGraph);
        for (int i = 0; i < args.size(); ++i) {
            Node arg = args.get(i);
            if (arg == null) continue;
            initialBindings.add(this.getParameters().get(i).getName(), model.asRDFNode(arg));
        }
        for (MultiFunctionParameter param : this.getParameters()) {
            if (param.isOptional() || initialBindings.contains(param.getName())) continue;
            throw new IllegalArgumentException("Missing value for required multi-function parameter " + param.getName() + " at " + this.getURI());
        }
        DatasetWithDifferentDefaultModel ds = new DatasetWithDifferentDefaultModel(model, DatasetFactory.wrap((DatasetGraph)dataset));
        QueryExecution qexec = ARQFactory.get().createQueryExecution(this.query, ds, (QuerySolution)initialBindings);
        ResultSet rs = qexec.execSelect();
        Iterator bindings = Iter.map((Iterator)rs, qs -> JenaUtil.asBinding(qs));
        QueryIterator quit = QueryIterPlainWrapper.create((Iterator)bindings);
        QueryIterator result = QueryIteratorClosing.protect(quit, (AutoCloseable)qexec);
        return result;
    }

    private static class QueryIteratorClosing
    extends QueryIteratorWrapper {
        private final AutoCloseable closeable;

        static QueryIterator protect(QueryIterator qIter, AutoCloseable closeable) {
            if (qIter instanceof QueryIteratorClosing) {
                throw new IllegalArgumentException("Wrapping an already wrapped QueryIteratorClosing");
            }
            return new QueryIteratorClosing(qIter, closeable);
        }

        private QueryIteratorClosing(QueryIterator qIter, AutoCloseable closeable) {
            super(qIter);
            this.closeable = closeable;
        }

        protected boolean hasNextBinding() {
            try {
                return super.hasNextBinding();
            }
            catch (RuntimeException ex) {
                this.closeInternal();
                throw ex;
            }
        }

        protected Binding moveToNextBinding() {
            try {
                return super.moveToNextBinding();
            }
            catch (RuntimeException ex) {
                this.closeInternal();
                throw ex;
            }
        }

        protected void closeIterator() {
            this.closeInternal();
            super.closeIterator();
        }

        protected void requestCancel() {
            this.closeInternal();
            super.requestCancel();
        }

        private void closeInternal() {
            try {
                this.closeable.close();
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new IllegalStateException("Unexpected checked exception", ex);
            }
        }
    }
}

