/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.optimize;

import java.util.LinkedList;
import java.util.List;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.topbraid.jenax.util.JenaDatatypes;
import org.topbraid.jenax.util.JenaNodeUtil;
import org.topbraid.shacl.optimize.OWLClassPropertyMetadataPlugin;
import org.topbraid.shacl.util.SHACLUtil;
import org.topbraid.shacl.vocabulary.SH;
import org.topbraid.shacl.vocabulary.TOSH;

public class ClassPropertyMetadata {
    private Node description;
    private Node editWidget;
    private boolean inverse;
    private Node localRange;
    private Integer maxCount;
    private Node name;
    private Node order;
    private Node predicate;
    private Node viewWidget;
    private static List<Plugin> plugins = new LinkedList<Plugin>();

    ClassPropertyMetadata(Node classNode, Node predicate, boolean inverse, Graph graph) {
        this.inverse = inverse;
        this.predicate = predicate;
        if (SHACLUtil.exists(graph)) {
            if (JenaNodeUtil.isInstanceOf(classNode, SH.Shape.asNode(), graph)) {
                this.initFromShape(classNode, graph);
            }
            ExtendedIterator it = graph.find(null, SH.targetClass.asNode(), classNode);
            while (it.hasNext()) {
                Node shape = ((Triple)it.next()).getSubject();
                this.initFromShape(shape, graph);
            }
        }
        if (!inverse) {
            for (Plugin plugin : plugins) {
                plugin.init(this, classNode, graph);
            }
        }
    }

    public Node getDescription() {
        return this.description;
    }

    public Node getEditWidget() {
        return this.editWidget;
    }

    public Node getLocalRange() {
        return this.localRange;
    }

    public Integer getMaxCount() {
        return this.maxCount;
    }

    public Node getName() {
        return this.name;
    }

    public Node getOrder() {
        return this.order;
    }

    public Node getPredicate() {
        return this.predicate;
    }

    public Node getViewWidget() {
        return this.viewWidget;
    }

    private void initFromShape(Node shape, Graph graph) {
        if (!graph.contains(shape, SH.deactivated.asNode(), JenaDatatypes.TRUE.asNode())) {
            this.initFromShape(shape, SH.property.asNode(), graph);
            this.initFromShape(shape, SH.parameter.asNode(), graph);
        }
    }

    private void initFromShape(Node shape, Node systemPredicate, Graph graph) {
        ExtendedIterator it = graph.find(shape, systemPredicate, Node.ANY);
        while (it.hasNext()) {
            Object value;
            Node maxCountNode;
            Node propertyShape = ((Triple)it.next()).getObject();
            if (propertyShape.isLiteral() || !this.hasMatchingPath(propertyShape, graph) || graph.contains(propertyShape, SH.deactivated.asNode(), JenaDatatypes.TRUE.asNode())) continue;
            if (this.description == null) {
                this.description = JenaNodeUtil.getObject(propertyShape, SH.description.asNode(), graph);
            }
            if (this.localRange == null && !this.inverse) {
                this.localRange = SHACLUtil.walkPropertyShapesHelper(propertyShape, graph);
            }
            if (this.maxCount == null && (maxCountNode = JenaNodeUtil.getObject(propertyShape, SH.maxCount.asNode(), graph)) != null && maxCountNode.isLiteral() && (value = maxCountNode.getLiteralValue()) instanceof Number) {
                this.maxCount = ((Number)value).intValue();
            }
            if (this.name == null) {
                this.name = JenaNodeUtil.getObject(propertyShape, SH.name.asNode(), graph);
            }
            if (this.order == null) {
                this.order = JenaNodeUtil.getObject(propertyShape, SH.order.asNode(), graph);
            }
            if (this.viewWidget != null) continue;
            this.viewWidget = JenaNodeUtil.getObject(propertyShape, TOSH.viewWidget.asNode(), graph);
        }
    }

    public boolean hasMatchingPath(Node propertyShape, Graph graph) {
        if (this.inverse) {
            Node path = JenaNodeUtil.getObject(propertyShape, SH.path.asNode(), graph);
            if (path != null && path.isBlank()) {
                return this.predicate.equals((Object)JenaNodeUtil.getObject(path, SH.inversePath.asNode(), graph));
            }
            return false;
        }
        return graph.contains(propertyShape, SH.path.asNode(), this.predicate);
    }

    public boolean isInverse() {
        return this.inverse;
    }

    public void setLocalRange(Node value) {
        this.localRange = value;
    }

    public void setMaxCount(int value) {
        this.maxCount = value;
    }

    public String toString() {
        return "ClassPropertyMetadata for " + (this.inverse ? "^" : "") + this.predicate;
    }

    public static void register(Plugin plugin) {
        plugins.add(plugin);
    }

    static {
        ClassPropertyMetadata.register(new OWLClassPropertyMetadataPlugin());
    }

    public static interface Plugin {
        public void init(ClassPropertyMetadata var1, Node var2, Graph var3);
    }
}

