/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.testcases;

import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.topbraid.jenax.functions.CurrentThreadFunctionRegistry;
import org.topbraid.jenax.util.ARQFactory;
import org.topbraid.shacl.testcases.TestCase;
import org.topbraid.shacl.testcases.TestCaseType;
import org.topbraid.shacl.vocabulary.DASH;

public class JSTestCaseType
extends TestCaseType {
    public JSTestCaseType() {
        super(DASH.JSTestCase);
    }

    @Override
    protected TestCase createTestCase(Resource graph, Resource resource) {
        return new JSTestCase(graph, resource);
    }

    private static class JSTestCase
    extends TestCase {
        JSTestCase(Resource graph, Resource resource) {
            super(graph, resource);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run(Model results) {
            block20: {
                Resource testCase = this.getResource();
                Runnable tearDownCTFR = CurrentThreadFunctionRegistry.register(testCase.getModel());
                Statement expectedResultS = testCase.getProperty(DASH.expectedResult);
                String queryString = "SELECT (<" + this.getResource() + ">() AS ?result) WHERE {}";
                Query query = ARQFactory.get().createQuery(testCase.getModel(), queryString);
                try (QueryExecution qexec = ARQFactory.get().createQueryExecution(query, testCase.getModel());){
                    ResultSet rs = qexec.execSelect();
                    if (!rs.hasNext()) {
                        if (expectedResultS != null) {
                            this.createFailure(results, "Expression returned no result, but expected: " + expectedResultS.getObject());
                            return;
                        }
                        break block20;
                    }
                    RDFNode result = rs.next().get("result");
                    if (expectedResultS == null) {
                        if (result != null) {
                            this.createFailure(results, "Expression returned a result, but none expected: " + result);
                            return;
                        }
                    } else if (!expectedResultS.getObject().equals(result)) {
                        this.createFailure(results, "Mismatching result. Expected: " + expectedResultS.getObject() + ". Found: " + result);
                        return;
                    }
                }
                finally {
                    tearDownCTFR.run();
                }
            }
            this.createResult(results, DASH.SuccessTestCaseResult);
        }
    }
}

