/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.testcases;

import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.topbraid.jenax.util.JenaDatatypes;
import org.topbraid.jenax.util.JenaUtil;
import org.topbraid.shacl.testcases.TestCase;
import org.topbraid.shacl.vocabulary.SH;

public abstract class TestCaseType {
    private final Resource testCaseClass;

    public TestCaseType(Resource testCaseClass) {
        this.testCaseClass = testCaseClass;
    }

    protected boolean filterTestCase(Resource possibleTestCase) {
        return !possibleTestCase.hasProperty(SH.deactivated, (RDFNode)JenaDatatypes.TRUE);
    }

    protected abstract TestCase createTestCase(Resource var1, Resource var2);

    public Collection<TestCase> getTestCases(Model model, Resource graph) {
        return JenaUtil.getAllInstances(this.testCaseClass.inModel(model)).stream().filter(this::filterTestCase).map(resource -> this.createTestCase(graph, (Resource)resource)).collect(Collectors.toList());
    }
}

