/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.util;

import java.util.Comparator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.topbraid.shacl.vocabulary.SH;

public class OrderThenPathLocalNameComparator
implements Comparator<Resource> {
    private static final OrderThenPathLocalNameComparator singleton = new OrderThenPathLocalNameComparator();

    public static OrderThenPathLocalNameComparator get() {
        return singleton;
    }

    @Override
    public int compare(Resource subject1, Resource subject2) {
        int byOrder = this.getOrder(subject1).compareTo(this.getOrder(subject2));
        if (byOrder != 0) {
            return byOrder;
        }
        Resource path1 = subject1.getPropertyResourceValue(SH.path);
        Resource path2 = subject2.getPropertyResourceValue(SH.path);
        if (path1 != null && path1.isURIResource() && path2 != null && path2.isURIResource()) {
            return path1.getLocalName().compareTo(path2.getLocalName());
        }
        return 0;
    }

    private Double getOrder(Resource subject) {
        Statement s = subject.getProperty(SH.order);
        if (s != null && s.getObject().isLiteral() && s.getLiteral().getValue() instanceof Number) {
            return ((Number)s.getLiteral().getValue()).doubleValue();
        }
        return 0.0;
    }
}

