/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.validation;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.jena.atlas.json.JsonArray;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.atlas.json.JsonValue;
import org.apache.jena.graph.Node;
import org.topbraid.shacl.engine.Constraint;

public class ValidationProfile {
    private Map<Node, Long> componentCounts = new ConcurrentHashMap<Node, Long>();
    private Map<Node, Long> componentDurations = new ConcurrentHashMap<Node, Long>();
    private Map<Node, Integer> componentFNCs = new ConcurrentHashMap<Node, Integer>();
    private Map<Node, Long> componentVNCs = new ConcurrentHashMap<Node, Long>();
    private Map<Node, Long> shapeCounts = new ConcurrentHashMap<Node, Long>();
    private Map<Node, Long> shapeDurations = new ConcurrentHashMap<Node, Long>();
    private Map<Node, Integer> shapeFNCs = new ConcurrentHashMap<Node, Integer>();
    private Map<Node, Long> shapeVNCs = new ConcurrentHashMap<Node, Long>();

    public void record(long duration, int focusNodeCount, long valueNodeCount, Constraint constraint) {
        this.record(this.componentCounts, this.componentDurations, this.componentFNCs, this.componentVNCs, constraint.getComponent().asNode(), duration, focusNodeCount, valueNodeCount);
        this.record(this.shapeCounts, this.shapeDurations, this.shapeFNCs, this.shapeVNCs, constraint.getShape().getShapeResource().asNode(), duration, focusNodeCount, valueNodeCount);
    }

    private void record(Map<Node, Long> counts, Map<Node, Long> durations, Map<Node, Integer> focusNodeCounts, Map<Node, Long> valueNodeCounts, Node key, long duration, int focusNodeCount, long valueNodeCount) {
        Long count;
        Long totalDuration = durations.computeIfAbsent(key, n -> 0L);
        totalDuration = totalDuration + duration;
        durations.put(key, totalDuration);
        Long l = count = counts.computeIfAbsent(key, n -> 0L);
        Long l2 = count = Long.valueOf(count + 1L);
        counts.put(key, count);
        Integer fnc = focusNodeCounts.computeIfAbsent(key, n -> 0);
        fnc = fnc + focusNodeCount;
        focusNodeCounts.put(key, fnc);
        Long vnc = valueNodeCounts.computeIfAbsent(key, n -> 0L);
        vnc = vnc + valueNodeCount;
        valueNodeCounts.put(key, vnc);
    }

    public JsonObject toJson() {
        JsonObject result = new JsonObject();
        JsonArray components = new JsonArray();
        for (Node component : this.componentCounts.keySet()) {
            JsonObject o = new JsonObject();
            o.put("uri", (String)(component.isURI() ? component.getURI() : "_:" + component.getBlankNodeLabel()));
            o.put("calls", this.componentCounts.get(component).longValue());
            o.put("ms", this.componentDurations.get(component).longValue());
            o.put("focusNodes", (long)this.componentFNCs.get(component).intValue());
            o.put("valueNodes", this.componentVNCs.get(component).longValue());
            components.add((JsonValue)o);
        }
        result.put("components", (JsonValue)components);
        JsonArray shapes = new JsonArray();
        for (Node shape : this.shapeCounts.keySet()) {
            JsonObject o = new JsonObject();
            o.put("uri", (String)(shape.isURI() ? shape.getURI() : "_:" + shape.getBlankNodeLabel()));
            o.put("calls", this.shapeCounts.get(shape).longValue());
            o.put("ms", this.shapeDurations.get(shape).longValue());
            o.put("focusNodes", (long)this.shapeFNCs.get(shape).intValue());
            o.put("valueNodes", this.shapeVNCs.get(shape).longValue());
            shapes.add((JsonValue)o);
        }
        result.put("shapes", (JsonValue)shapes);
        return result;
    }
}

