/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.jenax.util;

import java.net.http.HttpClient;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.jena.graph.Node;
import org.apache.jena.http.HttpEnv;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.core.DatasetImpl;
import org.apache.jena.sparql.exec.http.QueryExecutionHTTP;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementNamedGraph;
import org.apache.jena.sparql.syntax.ElementVisitor;
import org.apache.jena.sparql.syntax.ElementVisitorBase;
import org.apache.jena.sparql.syntax.ElementWalker;
import org.apache.jena.update.UpdateRequest;
import org.topbraid.jenax.util.BasicAuthenticator;
import org.topbraid.jenax.util.ExtraPrefixes;
import org.topbraid.jenax.util.FromDataset;
import org.topbraid.jenax.util.JenaUtil;
import org.topbraid.jenax.util.QueryExecutionFactoryFilter;
import org.topbraid.jenax.util.UpdateFactoryFilter;

public class ARQFactory {
    private static ARQFactory singleton = new ARQFactory();
    private Map<String, Query> string2Query = new ConcurrentHashMap<String, Query>();
    private Map<String, UpdateRequest> string2Update = new ConcurrentHashMap<String, UpdateRequest>();
    private boolean useCaches = true;
    public static boolean LOG_QUERIES = false;

    public static ARQFactory get() {
        return singleton;
    }

    public static Model getNamedModel(String graphURI) {
        return ARQFactory.get().getDataset(null).getNamedModel(graphURI);
    }

    public static void set(ARQFactory value) {
        singleton = value;
    }

    protected void adjustQueryExecution(QueryExecution qexec) {
    }

    public void clearCaches() {
        this.string2Query.clear();
        this.string2Update.clear();
    }

    public Query createExpressionQuery(String expression) {
        Query result = this.string2Query.get(expression);
        if (result == null) {
            String queryString = "SELECT (" + expression + ") WHERE {}";
            result = this.doCreateQuery(queryString);
            if (this.useCaches) {
                this.string2Query.put(expression, result);
            }
        }
        return result;
    }

    public String createPrefixDeclarations(Model model) {
        return this.createPrefixDeclarations(model, true);
    }

    public String createPrefixDeclarations(Model model, boolean includeExtraPrefixes) {
        StringBuffer queryString = new StringBuffer();
        String defaultNamespace = JenaUtil.getNsPrefixURI(model, "");
        if (defaultNamespace != null) {
            queryString.append("PREFIX :   <" + defaultNamespace + ">\n");
        }
        Map map = model.getNsPrefixMap();
        if (includeExtraPrefixes) {
            Map<String, String> extraPrefixes = ExtraPrefixes.getExtraPrefixes();
            for (String prefix2 : extraPrefixes.keySet()) {
                String ns = extraPrefixes.get(prefix2);
                ARQFactory.perhapsAppend(queryString, prefix2, ns, map);
            }
        }
        map.forEach((prefix, namespace) -> {
            if (!prefix.isEmpty() && namespace != null) {
                queryString.append("PREFIX " + prefix + ": <" + namespace + ">\n");
            }
        });
        return queryString.toString();
    }

    public Query createQuery(String queryString) {
        Query result = this.string2Query.get(queryString);
        if (result == null) {
            result = this.doCreateQuery(queryString);
            if (this.useCaches) {
                this.string2Query.put(queryString, result);
            }
        }
        return result;
    }

    public Query doCreateQuery(String queryString) {
        return this.doCreateQuery(queryString, null);
    }

    protected Query doCreateQuery(String queryString, PrefixMapping prefixMapping) {
        Query query = new Query();
        if (prefixMapping != null) {
            query.setPrefixMapping(prefixMapping);
        }
        return QueryFactory.parse((Query)query, (String)queryString, null, (Syntax)this.getSyntax());
    }

    public Query createQuery(Model model, String partialQuery) {
        PrefixMapping pm = ExtraPrefixes.createPrefixMappingWithExtraPrefixes(model);
        return this.doCreateQuery(partialQuery, pm);
    }

    public Query createQueryWithPrefixMapping(String partialQuery, PrefixMapping prefixMapping) {
        return this.doCreateQuery(partialQuery, prefixMapping);
    }

    public QueryExecution createQueryExecution(Query query, Model model) {
        return this.createQueryExecution(query, model, null);
    }

    public QueryExecution createQueryExecution(Query query, Model model, QuerySolution initialBinding) {
        Dataset dataset = this.getDataset(model);
        if (dataset == null) {
            dataset = DatasetFactory.create((Model)model);
        }
        return this.createQueryExecution(query, dataset, initialBinding);
    }

    public QueryExecution createQueryExecution(Query query, Dataset dataset) {
        return this.createQueryExecution(query, dataset, null);
    }

    public QueryExecution createQueryExecution(Query query, Dataset dataset, QuerySolution initialBinding) {
        if (!query.getGraphURIs().isEmpty() || !query.getNamedGraphURIs().isEmpty()) {
            dataset = new FromDataset(dataset, query);
        }
        if (LOG_QUERIES) {
            System.err.println("~~ ~~");
            System.err.println(initialBinding);
            System.err.println(query);
        }
        QueryExecution qexec = QueryExecutionFactoryFilter.get().create(query, dataset, initialBinding);
        this.adjustQueryExecution(qexec);
        return qexec;
    }

    public QueryExecutionHTTP createRemoteQueryExecution(Query query) {
        List graphURIs = query.getGraphURIs();
        return this.createRemoteQueryExecution(query, graphURIs);
    }

    public QueryExecutionHTTP createRemoteQueryExecution(Query query, List<String> graphURIs) {
        String service;
        String serviceAsURI = service = graphURIs.get(0);
        if (service.endsWith("/sparql")) {
            serviceAsURI = service.substring(0, service.lastIndexOf(47));
        }
        return this.createRemoteQueryExecution(service, query, Collections.singletonList(serviceAsURI), graphURIs, null, null);
    }

    public QueryExecutionHTTP createRemoteQueryExecution(String service, Query query, List<String> defaultGraphURIs, List<String> namedGraphURIs, String user, String password) {
        HttpClient httpClient = ARQFactory.buildHttpClient(user, password);
        return QueryExecutionFactoryFilter.get().sparqlService(service, query, httpClient, defaultGraphURIs, namedGraphURIs);
    }

    public static HttpClient buildHttpClient(String user, String password) {
        return user == null ? HttpEnv.getDftHttpClient() : HttpEnv.httpClientBuilder().authenticator(BasicAuthenticator.with(user, password)).build();
    }

    public UpdateRequest createUpdateRequest(String parsableString) {
        UpdateRequest result = this.string2Update.get(parsableString);
        if (result == null) {
            result = UpdateFactoryFilter.get().create(parsableString);
            if (this.useCaches) {
                this.string2Update.put(parsableString, result);
            }
        }
        return result;
    }

    public Dataset getDataset(Model defaultModel) {
        if (defaultModel != null) {
            return new DatasetImpl(defaultModel);
        }
        return new DatasetImpl(JenaUtil.createMemoryModel());
    }

    public static List<String> getNamedGraphURIs(Query query) {
        final LinkedList<String> results = new LinkedList<String>();
        ElementWalker.walk((Element)query.getQueryPattern(), (ElementVisitor)new ElementVisitorBase(){

            public void visit(ElementNamedGraph el) {
                String uri;
                Node node = el.getGraphNameNode();
                if (node != null && node.isURI() && !results.contains(uri = node.getURI())) {
                    results.add(uri);
                }
            }
        });
        return results;
    }

    public Syntax getSyntax() {
        return Syntax.syntaxARQ;
    }

    public boolean isUsingCaches() {
        return this.useCaches;
    }

    private static void perhapsAppend(StringBuffer queryString, String prefix, String namespace, Map<String, String> map) {
        if (!map.containsKey(prefix) && namespace != null) {
            queryString.append("PREFIX ");
            queryString.append(prefix);
            queryString.append(": <");
            queryString.append(namespace);
            queryString.append(">\n");
        }
    }

    public void setUseCaches(boolean value) {
        this.useCaches = value;
    }
}

