/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.arq.functions;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.core.DatasetGraph;
import org.topbraid.shacl.multifunctions.AbstractMultiFunction1;
import org.topbraid.shacl.util.SHACLUtil;
import org.topbraid.shacl.vocabulary.TOSH;

public class TargetContainsMultiFunction
extends AbstractMultiFunction1 {
    public TargetContainsMultiFunction() {
        super(TOSH.targetContains.getURI(), Arrays.asList("target", "shapesGraph"), "focusNode");
    }

    @Override
    protected Iterator<Node> executeIterator(List<Node> args, Graph activeGraph, DatasetGraph dataset) {
        Node targetNode = args.get(0);
        Node shapesGraphNode = args.get(1);
        Model model = ModelFactory.createModelForGraph((Graph)dataset.getGraph(shapesGraphNode));
        Resource target = (Resource)model.asRDFNode(targetNode);
        HashSet<Node> focusNodes = new HashSet<Node>();
        SHACLUtil.addNodesInTarget(target, DatasetFactory.wrap((DatasetGraph)dataset), focusNodes);
        return focusNodes.iterator();
    }
}

