/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.validation;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.RDF;
import org.topbraid.jenax.util.JenaUtil;

public class ClassesCache {
    private Map<Resource, Predicate<Resource>> predicates = new ConcurrentHashMap<Resource, Predicate<Resource>>();

    public Predicate<Resource> getPredicate(Resource cls) {
        return this.predicates.computeIfAbsent(cls, c -> {
            Set<Resource> classes = JenaUtil.getAllSubClassesStar(c);
            if (classes.size() == 1) {
                return new ClassPredicate((Resource)c);
            }
            return new SubClassesPredicate(classes);
        });
    }

    private static class ClassPredicate
    implements Predicate<Resource> {
        private Resource cls;

        ClassPredicate(Resource cls) {
            this.cls = cls;
        }

        @Override
        public boolean test(Resource instance) {
            return instance.hasProperty(RDF.type, (RDFNode)this.cls);
        }
    }

    private static class SubClassesPredicate
    implements Predicate<Resource> {
        private Set<Resource> classes;

        SubClassesPredicate(Set<Resource> classes) {
            this.classes = classes;
        }

        @Override
        public boolean test(Resource instance) {
            StmtIterator it = instance.listProperties(RDF.type);
            while (it.hasNext()) {
                if (!this.classes.contains(((Statement)it.next()).getObject())) continue;
                it.close();
                return true;
            }
            return false;
        }
    }
}

