/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.expr;

import java.util.Collections;
import java.util.List;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.topbraid.shacl.expr.NodeExpression;
import org.topbraid.shacl.expr.NodeExpressionContext;

public abstract class AbstractNodeExpression
implements NodeExpression {
    private static final List<NodeExpression> EMPTY = Collections.emptyList();
    private final RDFNode expr;

    protected AbstractNodeExpression(RDFNode expr) {
        this.expr = expr;
    }

    @Override
    public ExtendedIterator<RDFNode> evalReverse(RDFNode valueNode, NodeExpressionContext context) {
        throw new IllegalStateException("Reverse evaluation is not supported for this node expression: " + this);
    }

    @Override
    public List<NodeExpression> getInputExpressions() {
        return EMPTY;
    }

    @Override
    public Resource getOutputShape(Resource contextShape) {
        return null;
    }

    @Override
    public RDFNode getRDFNode() {
        return this.expr;
    }

    @Override
    public boolean isReversible(NodeExpressionContext context) {
        return false;
    }

    public String toString() {
        return this.getFunctionalSyntax();
    }
}

