/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.expr;

import java.util.LinkedList;
import java.util.Map;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.path.P_Inverse;
import org.apache.jena.sparql.path.P_Link;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;
import org.apache.jena.vocabulary.RDFS;
import org.topbraid.jenax.util.JenaUtil;
import org.topbraid.shacl.arq.SHACLPaths;
import org.topbraid.shacl.engine.ShapesGraph;
import org.topbraid.shacl.expr.NodeExpression;
import org.topbraid.shacl.expr.NodeExpressionContext;
import org.topbraid.shacl.expr.lib.DistinctExpression;

public class PathEvaluator {
    private NodeExpression input;
    private boolean isInverse;
    private Path jenaPath;
    private Property predicate;

    public PathEvaluator(Property predicate) {
        this.predicate = predicate;
    }

    public PathEvaluator(Path path, Model shapesModel) {
        this.jenaPath = path;
        boolean bl = this.isInverse = this.jenaPath instanceof P_Inverse && ((P_Inverse)this.jenaPath).getSubPath() instanceof P_Link;
        if (this.isInverse) {
            P_Link link = (P_Link)((P_Inverse)this.jenaPath).getSubPath();
            this.predicate = shapesModel.getProperty(link.getNode().getURI());
        }
    }

    public ExtendedIterator<RDFNode> eval(RDFNode focusNode, NodeExpressionContext context) {
        if (this.input == null) {
            ExtendedIterator<RDFNode> asserted = this.evalFocusNode(focusNode, context);
            return this.withDefaultValues(this.withInferences(asserted, focusNode, context), focusNode, context);
        }
        ExtendedIterator<RDFNode> it = this.input.eval(focusNode, context);
        if (it.hasNext()) {
            RDFNode first = (RDFNode)it.next();
            ExtendedIterator result = this.withDefaultValues(this.withInferences(this.evalFocusNode(first, context), first, context), first, context);
            while (it.hasNext()) {
                RDFNode n = (RDFNode)it.next();
                result = result.andThen(this.withDefaultValues(this.withInferences(this.evalFocusNode(n, context), n, context), first, context));
            }
            return result;
        }
        return WrappedIterator.emptyIterator();
    }

    public ExtendedIterator<RDFNode> evalReverse(RDFNode valueNode, NodeExpressionContext context) {
        if (this.isInverse) {
            if (valueNode instanceof Literal) {
                return WrappedIterator.emptyIterator();
            }
            return context.getDataset().getDefaultModel().listObjectsOfProperty((Resource)valueNode, this.predicate);
        }
        return context.getDataset().getDefaultModel().listSubjectsWithProperty(this.predicate, valueNode).mapWith(r -> r);
    }

    public Path getJenaPath() {
        return this.jenaPath;
    }

    public Property getPredicate() {
        if (this.predicate != null && !this.isInverse) {
            return this.predicate;
        }
        return null;
    }

    public boolean isMaybeInferred(ShapesGraph shapesGraph) {
        if (this.predicate != null && !this.isInverse) {
            return !shapesGraph.getValuesNodeExpressionsMap((Resource)this.predicate).isEmpty() || !shapesGraph.getDefaultValueNodeExpressionsMap((Resource)this.predicate).isEmpty();
        }
        return false;
    }

    public boolean isReversible(ShapesGraph shapesGraph) {
        return this.input == null && !this.isMaybeInferred(shapesGraph) && this.jenaPath == null;
    }

    public void setInput(NodeExpression input) {
        this.input = input;
    }

    private ExtendedIterator<RDFNode> evalFocusNode(RDFNode focusNode, NodeExpressionContext context) {
        if (this.jenaPath == null) {
            if (focusNode.isLiteral()) {
                return WrappedIterator.emptyIterator();
            }
            return context.getDataset().getDefaultModel().listObjectsOfProperty((Resource)focusNode, this.predicate);
        }
        if (this.isInverse) {
            return context.getDataset().getDefaultModel().listSubjectsWithProperty(this.predicate, focusNode).mapWith(r -> r);
        }
        LinkedList<RDFNode> results = new LinkedList<RDFNode>();
        SHACLPaths.addValueNodes(focusNode.inModel(context.getDataset().getDefaultModel()), this.jenaPath, results);
        return WrappedIterator.create(results.iterator());
    }

    private ExtendedIterator<RDFNode> withDefaultValues(ExtendedIterator<RDFNode> base, RDFNode focusNode, NodeExpressionContext context) {
        if (this.isInverse || this.predicate == null || base.hasNext()) {
            return base;
        }
        Map<Node, NodeExpression> map = context.getShapesGraph().getDefaultValueNodeExpressionsMap((Resource)this.predicate);
        if (map.isEmpty()) {
            return base;
        }
        ExtendedIterator result = WrappedIterator.emptyIterator();
        int count = 0;
        for (Resource type : JenaUtil.getAllTypes((Resource)focusNode)) {
            NodeExpression expr = map.get(type.asNode());
            if (expr == null) continue;
            result = result.andThen(expr.eval(focusNode, context));
            ++count;
        }
        if (count > 1) {
            return DistinctExpression.distinct((ExtendedIterator<RDFNode>)result);
        }
        return result;
    }

    private ExtendedIterator<RDFNode> withInferences(ExtendedIterator<RDFNode> base, RDFNode focusNode, NodeExpressionContext context) {
        Map<Node, NodeExpression> map;
        if (this.predicate != null && !this.isInverse && focusNode.isResource() && !(map = context.getShapesGraph().getValuesNodeExpressionsMap((Resource)this.predicate)).isEmpty()) {
            ExtendedIterator result = base;
            boolean hasInferences = false;
            for (Resource type : JenaUtil.getAllTypes((Resource)focusNode)) {
                NodeExpression expr = map.get(type.asNode());
                if (expr == null) continue;
                result = result.andThen(expr.eval(focusNode, context));
                hasInferences = true;
            }
            if (!hasInferences && map.get(RDFS.Resource.asNode()) != null) {
                NodeExpression expr = map.get(RDFS.Resource.asNode());
                result = result.andThen(expr.eval(focusNode, context));
                hasInferences = true;
            }
            return DistinctExpression.distinct(result);
        }
        return base;
    }
}

