/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.model.impl;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.topbraid.jenax.util.JenaDatatypes;
import org.topbraid.jenax.util.JenaUtil;
import org.topbraid.shacl.model.SHParameter;
import org.topbraid.shacl.model.SHParameterizable;
import org.topbraid.shacl.model.impl.SHResourceImpl;
import org.topbraid.shacl.vocabulary.SH;

public class SHParameterizableImpl
extends SHResourceImpl
implements SHParameterizable {
    public SHParameterizableImpl(Node node, EnhGraph graph) {
        super(node, graph);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SHParameter> getParameters() {
        LinkedList<SHParameter> results = new LinkedList<SHParameter>();
        StmtIterator it = null;
        JenaUtil.setGraphReadOptimization(true);
        try {
            Set<Resource> classes = JenaUtil.getAllSuperClasses(this);
            classes.add(this);
            for (Resource cls : classes) {
                it = cls.listProperties(SH.parameter);
                while (it.hasNext()) {
                    Resource param = ((Statement)it.next()).getResource();
                    results.add((SHParameter)param.as(SHParameter.class));
                }
            }
        }
        finally {
            if (it != null) {
                it.close();
            }
            JenaUtil.setGraphReadOptimization(false);
        }
        return results;
    }

    @Override
    public Map<String, SHParameter> getParametersMap() {
        HashMap<String, SHParameter> results = new HashMap<String, SHParameter>();
        for (SHParameter parameter : this.getParameters()) {
            Property property = parameter.getPredicate();
            if (property == null) continue;
            results.put(property.getLocalName(), parameter);
        }
        return results;
    }

    @Override
    public String getLabelTemplate() {
        return JenaUtil.getStringProperty(this, SH.labelTemplate);
    }

    @Override
    public List<SHParameter> getOrderedParameters() {
        List<SHParameter> results = this.getParameters();
        boolean orderExists = false;
        for (SHParameter param : results) {
            if (!param.hasProperty(SH.order)) continue;
            orderExists = true;
            break;
        }
        if (orderExists) {
            Collections.sort(results, new Comparator<SHParameter>(){

                @Override
                public int compare(SHParameter param1, SHParameter param2) {
                    Property p1 = param1.getPredicate();
                    Property p2 = param2.getPredicate();
                    if (p1 != null && p2 != null) {
                        int comp;
                        Integer index2;
                        Integer index1 = param1.getOrder();
                        if (index1 == null) {
                            index1 = 0;
                        }
                        if ((index2 = param2.getOrder()) == null) {
                            index2 = 0;
                        }
                        if ((comp = index1.compareTo(index2)) != 0) {
                            return comp;
                        }
                        return p1.getLocalName().compareTo(p2.getLocalName());
                    }
                    return 0;
                }
            });
        } else {
            Collections.sort(results, new Comparator<SHParameter>(){

                @Override
                public int compare(SHParameter param1, SHParameter param2) {
                    Property p1 = param1.getPredicate();
                    Property p2 = param2.getPredicate();
                    if (p1 != null && p2 != null) {
                        return p1.getLocalName().compareTo(p2.getLocalName());
                    }
                    return 0;
                }
            });
        }
        return results;
    }

    @Override
    public boolean isOptionalParameter(Property predicate) {
        for (SHParameter param : this.getParameters()) {
            if (!param.hasProperty(SH.path, (RDFNode)predicate) || !param.hasProperty(SH.optional, (RDFNode)JenaDatatypes.TRUE)) continue;
            return true;
        }
        return false;
    }
}

