/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.rules;

import java.net.URI;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.compose.MultiUnion;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.topbraid.jenax.progress.ProgressMonitor;
import org.topbraid.jenax.util.DatasetWithDifferentDefaultModel;
import org.topbraid.jenax.util.JenaUtil;
import org.topbraid.shacl.engine.ShapesGraph;
import org.topbraid.shacl.entailment.SHACLEntailment;
import org.topbraid.shacl.rules.RuleEngine;

public class RulesEntailment
implements SHACLEntailment.Engine {
    @Override
    public Model createModelWithEntailment(Dataset dataset, URI shapesGraphURI, ShapesGraph shapesGraph, ProgressMonitor monitor) throws InterruptedException {
        Model dataModel = dataset.getDefaultModel();
        Model inferencesModel = JenaUtil.createDefaultModel();
        MultiUnion unionGraph = new MultiUnion(new Graph[]{dataModel.getGraph(), inferencesModel.getGraph()});
        Model unionDataModel = ModelFactory.createModelForGraph((Graph)unionGraph);
        DatasetWithDifferentDefaultModel newDataset = new DatasetWithDifferentDefaultModel(unionDataModel, dataset);
        RuleEngine engine = new RuleEngine(newDataset, shapesGraphURI, shapesGraph, inferencesModel);
        engine.setExcludeNeverMaterialize(true);
        engine.setProgressMonitor(monitor);
        engine.executeAll();
        engine.executeAllDefaultValues();
        if (inferencesModel.isEmpty()) {
            return dataModel;
        }
        return unionDataModel;
    }
}

