/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.testcases;

import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.vocabulary.RDF;
import org.topbraid.jenax.functions.CurrentThreadFunctionRegistry;
import org.topbraid.jenax.util.ARQFactory;
import org.topbraid.jenax.util.JenaUtil;
import org.topbraid.shacl.engine.ShapesGraph;
import org.topbraid.shacl.engine.ShapesGraphFactory;
import org.topbraid.shacl.rules.RuleEngine;
import org.topbraid.shacl.testcases.TestCase;
import org.topbraid.shacl.testcases.TestCaseType;
import org.topbraid.shacl.testcases.context.TestCaseContextFactory;
import org.topbraid.shacl.util.ModelPrinter;
import org.topbraid.shacl.util.SHACLUtil;
import org.topbraid.shacl.vocabulary.DASH;

public class InferencingTestCaseType
extends TestCaseType {
    private static final List<TestCaseContextFactory> contextFactories = new LinkedList<TestCaseContextFactory>();

    public static void registerContextFactory(TestCaseContextFactory factory) {
        contextFactories.add(factory);
    }

    public InferencingTestCaseType() {
        super(DASH.InferencingTestCase);
    }

    @Override
    protected TestCase createTestCase(Resource graph, Resource resource) {
        return new InferencingTestCase(graph, resource);
    }

    private static class InferencingTestCase
    extends TestCase {
        InferencingTestCase(Resource graph, Resource resource) {
            super(graph, resource);
        }

        @Override
        public void run(Model results) {
            Resource testCase = this.getResource();
            Runnable tearDownCTFR = CurrentThreadFunctionRegistry.register(testCase.getModel());
            Model dataModel = this.getResource().getModel();
            Dataset dataset = ARQFactory.get().getDataset(dataModel);
            URI shapesGraphURI = SHACLUtil.withShapesGraph(dataset);
            ShapesGraph shapesGraph = ShapesGraphFactory.get().createShapesGraph(dataset.getNamedModel(shapesGraphURI.toString()));
            RuleEngine ruleEngine = new RuleEngine(dataset, shapesGraphURI, shapesGraph, dataModel);
            try {
                ruleEngine.executeAll();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            finally {
                tearDownCTFR.run();
            }
            Model actualResults = ruleEngine.getInferencesModel();
            Model expectedModel = JenaUtil.createDefaultModel();
            List expectedResults = this.getResource().listProperties(DASH.expectedResult).toList();
            boolean valid = false;
            for (Statement s : expectedResults) {
                valid = false;
                expectedModel.add(s);
                Resource expectedInferredNode = s.getObject().asResource();
                Triple expectedInferredNodeAsTriple = Triple.create((Node)expectedInferredNode.getProperty(RDF.subject).getObject().asNode(), (Node)expectedInferredNode.getProperty(RDF.predicate).getObject().asNode(), (Node)expectedInferredNode.getProperty(RDF.object).getObject().asNode());
                if (!actualResults.getGraph().contains(expectedInferredNodeAsTriple)) continue;
                valid = true;
            }
            if (valid) {
                this.createResult(results, DASH.SuccessTestCaseResult);
            } else {
                System.out.println("Expected: " + ModelPrinter.get().print(expectedModel) + "\nActual: " + ModelPrinter.get().print(actualResults));
                Resource failure = this.createFailure(results, "Mismatching inference results. Expected " + expectedModel.size() + " triples, found " + actualResults.size());
                failure.addProperty(DASH.expectedResult, ModelPrinter.get().print(expectedModel));
            }
        }
    }
}

