/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.testcases;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.compose.MultiUnion;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.vocabulary.DOAP;
import org.apache.jena.sparql.vocabulary.EARL;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.topbraid.jenax.util.ARQFactory;
import org.topbraid.jenax.util.ExceptionUtil;
import org.topbraid.jenax.util.JenaUtil;
import org.topbraid.shacl.arq.SHACLPaths;
import org.topbraid.shacl.engine.ShapesGraph;
import org.topbraid.shacl.engine.ShapesGraphFactory;
import org.topbraid.shacl.engine.filters.CoreConstraintFilter;
import org.topbraid.shacl.testcases.GraphValidationTestCaseType;
import org.topbraid.shacl.util.ModelPrinter;
import org.topbraid.shacl.validation.ValidationEngine;
import org.topbraid.shacl.validation.ValidationEngineConfiguration;
import org.topbraid.shacl.validation.ValidationEngineFactory;
import org.topbraid.shacl.vocabulary.DASH;
import org.topbraid.shacl.vocabulary.MF;
import org.topbraid.shacl.vocabulary.SH;
import org.topbraid.shacl.vocabulary.SHT;

public class W3CTestRunner {
    private static final Resource EARL_AUTHOR = ResourceFactory.createResource((String)"http://knublauch.com");
    private static final Resource EARL_SUBJECT = ResourceFactory.createResource((String)"http://topquadrant.com/shacl/api");
    private Model earl;
    private List<Item> items = new LinkedList<Item>();

    public W3CTestRunner(File rootManifest) throws IOException {
        this.earl = JenaUtil.createMemoryModel();
        JenaUtil.initNamespaces(this.earl.getGraph());
        this.earl.setNsPrefix("doap", "http://usefulinc.com/ns/doap#");
        this.earl.setNsPrefix("earl", "http://www.w3.org/ns/earl#");
        this.earl.add(EARL_SUBJECT, RDF.type, (RDFNode)DOAP.Project);
        this.earl.add(EARL_SUBJECT, RDF.type, (RDFNode)EARL.Software);
        this.earl.add(EARL_SUBJECT, RDF.type, (RDFNode)EARL.TestSubject);
        this.earl.add(EARL_SUBJECT, DOAP.developer, (RDFNode)EARL_AUTHOR);
        this.earl.add(EARL_SUBJECT, DOAP.name, "TopBraid SHACL API");
        this.collectItems(rootManifest, "urn:x:root/");
    }

    private void collectItems(File manifestFile, String baseURI) throws IOException {
        String filePath = manifestFile.getAbsolutePath().replaceAll("\\\\", "/");
        int coreIndex = filePath.indexOf("core/");
        if (coreIndex > 0 && !filePath.contains("sparql/core")) {
            filePath = filePath.substring(coreIndex);
        } else {
            int sindex = filePath.indexOf("sparql/");
            if (sindex > 0) {
                filePath = filePath.substring(sindex);
            }
        }
        Model model = JenaUtil.createMemoryModel();
        model.read((InputStream)new FileInputStream(manifestFile), baseURI, "TURTLE");
        for (Resource manifest : model.listSubjectsWithProperty(RDF.type, (RDFNode)MF.Manifest).toList()) {
            for (Resource include : JenaUtil.getResourceProperties(manifest, MF.include)) {
                String path = include.getURI().substring(baseURI.length());
                File includeFile = new File(manifestFile.getParentFile(), path);
                if (path.contains("/")) {
                    String addURI = path.substring(0, path.indexOf(47));
                    this.collectItems(includeFile, baseURI + addURI + "/");
                    continue;
                }
                this.collectItems(includeFile, baseURI + path);
            }
            for (Resource entries : JenaUtil.getResourceProperties(manifest, MF.entries)) {
                for (RDFNode entry : ((RDFList)entries.as(RDFList.class)).iterator().toList()) {
                    this.items.add(new Item(entry.asResource(), filePath, manifestFile));
                }
            }
        }
    }

    public Model getEARLModel() {
        return this.earl;
    }

    public List<Item> getItems() {
        return this.items;
    }

    public void run(PrintStream out) throws InterruptedException {
        long startTime = System.currentTimeMillis();
        out.println("Running " + this.items.size() + " W3C Test Cases...");
        int count = 0;
        for (Item item : this.items) {
            if (item.run(out)) continue;
            ++count;
        }
        out.println("Completed: " + count + " test failures (Duration: " + (System.currentTimeMillis() - startTime) + " ms)");
    }

    public class Item {
        Resource entry;
        String filePath;
        File manifestFile;

        Item(Resource entry, String filePath, File manifestFile) {
            this.entry = entry;
            this.filePath = filePath;
            this.manifestFile = manifestFile;
        }

        public Resource getEARLResource() {
            return ResourceFactory.createResource((String)("urn:x-shacl-test:" + this.entry.getURI().substring("urn:x:root".length())));
        }

        public String getFilePath() {
            return this.filePath;
        }

        public String getLabel() {
            return JenaUtil.getStringProperty(this.entry, RDFS.label);
        }

        public Resource getStatus() {
            return this.entry.getPropertyResourceValue(MF.status);
        }

        public boolean run(PrintStream out) throws InterruptedException {
            Resource assertion = W3CTestRunner.this.earl.createResource(EARL.Assertion);
            assertion.addProperty(EARL.assertedBy, (RDFNode)EARL_AUTHOR);
            assertion.addProperty(EARL.subject, (RDFNode)EARL_SUBJECT);
            assertion.addProperty(EARL.test, (RDFNode)this.getEARLResource());
            Resource result = W3CTestRunner.this.earl.createResource(EARL.TestResult);
            assertion.addProperty(EARL.result, (RDFNode)result);
            result.addProperty(EARL.mode, (RDFNode)EARL.automatic);
            Resource action = this.entry.getPropertyResourceValue(MF.action);
            Resource shapesGraphResource = action.getPropertyResourceValue(SHT.shapesGraph);
            Graph shapesBaseGraph = this.entry.getModel().getGraph();
            if (!(this.entry.getURI() + ".ttl").equals(shapesGraphResource.getURI())) {
                int last = shapesGraphResource.getURI().lastIndexOf(47);
                File shapesFile = new File(this.manifestFile.getParentFile(), shapesGraphResource.getURI().substring(last + 1));
                Model shapesModel = JenaUtil.createMemoryModel();
                try {
                    shapesModel.read((InputStream)new FileInputStream(shapesFile), "urn:x:dummy", "TURTLE");
                    shapesBaseGraph = shapesModel.getGraph();
                }
                catch (FileNotFoundException e) {
                    ExceptionUtil.throwUnchecked(e);
                }
            }
            MultiUnion multiUnion = new MultiUnion(new Graph[]{shapesBaseGraph, ARQFactory.getNamedModel("http://topbraid.org/tosh").getGraph(), ARQFactory.getNamedModel("http://datashapes.org/dash").getGraph(), ARQFactory.getNamedModel("http://www.w3.org/ns/shacl#").getGraph()});
            Model shapesModel = ModelFactory.createModelForGraph((Graph)multiUnion);
            Model dataModel = this.entry.getModel();
            Resource dataGraph = action.getPropertyResourceValue(SHT.dataGraph);
            if (!(this.entry.getURI() + ".ttl").equals(dataGraph.getURI())) {
                int last = dataGraph.getURI().lastIndexOf(47);
                File dataFile = new File(this.manifestFile.getParentFile(), dataGraph.getURI().substring(last + 1));
                dataModel = JenaUtil.createMemoryModel();
                try {
                    dataModel.read((InputStream)new FileInputStream(dataFile), "urn:x:dummy", "TURTLE");
                }
                catch (FileNotFoundException e) {
                    ExceptionUtil.throwUnchecked(e);
                }
            }
            URI shapesGraphURI = URI.create("urn:x-shacl-shapes-graph:" + UUID.randomUUID());
            Dataset dataset = ARQFactory.get().getDataset(dataModel);
            dataset.addNamedModel(shapesGraphURI.toString(), shapesModel);
            ShapesGraph shapesGraph = ShapesGraphFactory.get().createShapesGraph(shapesModel);
            ValidationEngineConfiguration configuration = new ValidationEngineConfiguration().setValidateShapes(false);
            if (this.entry.hasProperty(ResourceFactory.createProperty((String)"http://www.w3.org/2001/sw/DataAccess/tests/test-manifest#requires"), (RDFNode)SHT.CoreOnly)) {
                shapesGraph.setConstraintFilter(new CoreConstraintFilter());
            }
            ValidationEngine engine = ValidationEngineFactory.get().create(dataset, shapesGraphURI, shapesGraph, null);
            engine.setConfiguration(configuration);
            try {
                Resource actualReport = engine.validateAll();
                Model actualResults = actualReport.getModel();
                actualResults.setNsPrefix("sh", "http://www.w3.org/ns/shacl#");
                actualResults.setNsPrefix("rdf", RDF.getURI());
                actualResults.setNsPrefix("rdfs", RDFS.getURI());
                Model expectedModel = JenaUtil.createDefaultModel();
                Resource expectedReport = this.entry.getPropertyResourceValue(MF.result);
                for (Statement s : expectedReport.listProperties().toList()) {
                    expectedModel.add(s);
                }
                for (Statement s : expectedReport.listProperties(SH.result).toList()) {
                    for (Statement t : s.getResource().listProperties().toList()) {
                        if (t.getPredicate().equals(DASH.suggestion)) {
                            GraphValidationTestCaseType.addStatements(expectedModel, t);
                            continue;
                        }
                        if (SH.resultPath.equals(t.getPredicate())) {
                            expectedModel.add(t.getSubject(), t.getPredicate(), (RDFNode)SHACLPaths.clonePath(t.getResource(), expectedModel));
                            continue;
                        }
                        expectedModel.add(t);
                    }
                }
                actualResults.removeAll(null, SH.message, (RDFNode)null);
                for (Statement s : actualResults.listStatements(null, SH.resultMessage, (RDFNode)null).toList()) {
                    if (expectedModel.contains(null, SH.resultMessage, s.getObject())) continue;
                    actualResults.remove(s);
                }
                if (expectedModel.getGraph().isIsomorphicWith(actualResults.getGraph())) {
                    out.println("PASSED: " + this.entry);
                    result.addProperty(EARL.outcome, (RDFNode)EARL.passed);
                    return true;
                }
                out.println("FAILED: " + this.entry);
                result.addProperty(EARL.outcome, (RDFNode)EARL.failed);
                expectedModel.setNsPrefixes((PrefixMapping)actualResults);
                System.out.println("Expected\n" + ModelPrinter.get().print(expectedModel));
                System.out.println("Actual\n" + ModelPrinter.get().print(actualResults));
                return false;
            }
            catch (Exception ex) {
                if (this.entry.hasProperty(MF.result, (RDFNode)SHT.Failure)) {
                    out.println("PASSED: " + this.entry);
                    result.addProperty(EARL.outcome, (RDFNode)EARL.passed);
                    return true;
                }
                out.println("EXCEPTION: " + this.entry + " " + ex.getMessage());
                result.addProperty(EARL.outcome, (RDFNode)EARL.failed);
                return false;
            }
        }
    }
}

