/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.tools;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.topbraid.shacl.vocabulary.SH;

public class BlankNodeFinder {
    private static final Logger logger = LoggerFactory.getLogger(BlankNodeFinder.class);

    public static Model findBlankNodes(Model report, Model shapesGraph) {
        HashSet blankNodes = new HashSet();
        StmtIterator statements = report.listStatements(null, SH.result, (RDFNode)null);
        statements.mapWith(Statement::getResource).forEach(resource -> {
            try {
                StmtIterator reportStatements = report.listStatements(resource, null, (RDFNode)null);
                reportStatements.forEach(statement -> {
                    if (statement.getObject().isAnon()) {
                        Set<Statement> allBlankNodes = BlankNodeFinder.resolveAllBlankNodes(shapesGraph, statement.getResource(), blankNodes);
                        blankNodes.add(statement);
                        blankNodes.addAll(allBlankNodes);
                    }
                });
            }
            catch (Exception e) {
                logger.error("Error while processing blank node: " + resource.toString());
            }
        });
        return ModelFactory.createDefaultModel().add(new ArrayList(blankNodes));
    }

    private static Set<Statement> resolveAllBlankNodes(Model model, Resource subject, Set<Statement> blankNodes) {
        LinkedList<Resource> queue = new LinkedList<Resource>();
        queue.add(subject);
        while (!queue.isEmpty()) {
            Resource resource = (Resource)queue.remove();
            StmtIterator statements = model.listStatements(resource, null, (RDFNode)null);
            statements.forEachRemaining(statement -> {
                if (blankNodes.contains(statement)) {
                    return;
                }
                blankNodes.add((Statement)statement);
                if (statement.getObject().isAnon()) {
                    queue.add(statement.getResource());
                }
            });
        }
        return blankNodes;
    }
}

