/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.tools;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.jena.rdf.model.Model;
import org.topbraid.shacl.rules.RuleUtil;
import org.topbraid.shacl.tools.AbstractTool;

public class Infer
extends AbstractTool {
    public static void main(String[] args) throws IOException {
        PrintStream oldPS = System.err;
        System.setErr(new PrintStream(new ByteArrayOutputStream()));
        Infer infer = new Infer();
        System.setErr(oldPS);
        infer.run(args);
    }

    private void run(String[] args) throws IOException {
        Model dataModel = this.getDataModel(args);
        Model shapesModel = this.getShapesModel(args);
        if (shapesModel == null) {
            shapesModel = dataModel;
        }
        int maxIterations = this.getMaxIterations(args);
        int iteration = 0;
        Model results = null;
        do {
            Model newResults = RuleUtil.executeRules(dataModel, shapesModel, null, null);
            if (results == null) {
                results = newResults;
            } else {
                results.add(newResults);
            }
            if (newResults.size() == 0L || results.size() == newResults.size()) break;
            if (iteration >= maxIterations - 1) continue;
            dataModel.add(newResults);
        } while (++iteration < maxIterations);
        results.write((OutputStream)System.out, "TURTLE");
    }
}

