/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.validation;

import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.compose.MultiUnion;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.path.P_Inverse;
import org.apache.jena.sparql.path.P_Link;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.path.eval.PathEval;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.vocabulary.RDF;
import org.topbraid.jenax.util.ExceptionUtil;
import org.topbraid.jenax.util.JenaDatatypes;
import org.topbraid.jenax.util.JenaUtil;
import org.topbraid.jenax.util.RDFLabels;
import org.topbraid.shacl.arq.SHACLPaths;
import org.topbraid.shacl.engine.AbstractEngine;
import org.topbraid.shacl.engine.Constraint;
import org.topbraid.shacl.engine.SHACLScriptEngineManager;
import org.topbraid.shacl.engine.Shape;
import org.topbraid.shacl.engine.ShapesGraph;
import org.topbraid.shacl.engine.filters.ExcludeMetaShapesFilter;
import org.topbraid.shacl.expr.NodeExpression;
import org.topbraid.shacl.expr.NodeExpressionFactory;
import org.topbraid.shacl.model.SHNodeShape;
import org.topbraid.shacl.model.SHPropertyShape;
import org.topbraid.shacl.targets.InstancesTarget;
import org.topbraid.shacl.targets.Target;
import org.topbraid.shacl.util.FailureLog;
import org.topbraid.shacl.util.SHACLPreferences;
import org.topbraid.shacl.util.SHACLUtil;
import org.topbraid.shacl.validation.ClassesCache;
import org.topbraid.shacl.validation.ConstraintExecutor;
import org.topbraid.shacl.validation.MaximumNumberViolations;
import org.topbraid.shacl.validation.ResourceValidationReport;
import org.topbraid.shacl.validation.ValidationEngineConfiguration;
import org.topbraid.shacl.validation.ValidationProfile;
import org.topbraid.shacl.validation.ValidationReport;
import org.topbraid.shacl.validation.sparql.SPARQLSubstitutions;
import org.topbraid.shacl.vocabulary.DASH;
import org.topbraid.shacl.vocabulary.SH;

public class ValidationEngine
extends AbstractEngine {
    private static ThreadLocal<ValidationEngine> current = new ThreadLocal();
    private ClassesCache classesCache;
    private ValidationEngineConfiguration configuration;
    private Predicate<RDFNode> focusNodeFilter;
    private Model inferencesModel;
    private Function<RDFNode, String> labelFunction = node -> RDFLabels.get().getNodeLabel((RDFNode)node);
    private Map<RDFNode, String> labelsCache = new ConcurrentHashMap<RDFNode, String>();
    private ValidationProfile profile;
    private Resource report;
    private int resultsCount = 0;
    private Map<ValueNodesCacheKey, Collection<RDFNode>> valueNodes = new WeakHashMap<ValueNodesCacheKey, Collection<RDFNode>>();
    private int violationsCount = 0;

    public static ValidationEngine getCurrent() {
        return current.get();
    }

    public static void setCurrent(ValidationEngine value) {
        current.set(value);
    }

    protected ValidationEngine(Dataset dataset, URI shapesGraphURI, ShapesGraph shapesGraph, Resource report) {
        super(dataset, shapesGraph, shapesGraphURI);
        this.setConfiguration(new ValidationEngineConfiguration());
        if (report == null) {
            Model reportModel = JenaUtil.createMemoryModel();
            reportModel.setNsPrefixes((PrefixMapping)dataset.getDefaultModel());
            reportModel.withDefaultMappings((PrefixMapping)shapesGraph.getShapesModel());
            this.report = reportModel.createResource(SH.ValidationReport);
        } else {
            this.report = report;
        }
    }

    public RDFNode applyEntailments(Resource focusNode) {
        Model shapesModel = this.dataset.getNamedModel(this.shapesGraphURI.toString());
        if (shapesModel.contains(null, SH.entailment, (RDFNode)SH.Rules)) {
            if (this.inferencesModel == null) {
                this.inferencesModel = JenaUtil.createDefaultModel();
                Model dataModel = this.dataset.getDefaultModel();
                MultiUnion multiUnion = new MultiUnion(new Graph[]{dataModel.getGraph(), this.inferencesModel.getGraph()});
                multiUnion.setBaseGraph(dataModel.getGraph());
                this.dataset.setDefaultModel(ModelFactory.createModelForGraph((Graph)multiUnion));
            }
            HashMap<Property, RDFNode> defaultValueMap = new HashMap<Property, RDFNode>();
            for (SHNodeShape nodeShape : SHACLUtil.getAllShapesAtNode((RDFNode)focusNode)) {
                if (nodeShape.hasProperty(SH.deactivated, (RDFNode)JenaDatatypes.TRUE)) continue;
                for (SHPropertyShape ps : nodeShape.getPropertyShapes()) {
                    Statement defaultValue;
                    if (ps.hasProperty(SH.deactivated, (RDFNode)JenaDatatypes.TRUE)) continue;
                    Resource path = ps.getPath();
                    Statement values = ps.getProperty(SH.values);
                    if (values != null) {
                        NodeExpression ne = NodeExpressionFactory.get().create(values.getObject());
                        ne.eval((RDFNode)focusNode, this).forEachRemaining(v -> this.inferencesModel.getGraph().add(Triple.create((Node)focusNode.asNode(), (Node)path.asNode(), (Node)v.asNode())));
                    }
                    if ((defaultValue = ps.getProperty(SH.defaultValue)) == null) continue;
                    defaultValueMap.put(JenaUtil.asProperty(path), defaultValue.getObject());
                }
            }
            Model dataModel = this.dataset.getDefaultModel();
            Resource newFocusNode = focusNode.inModel(dataModel);
            for (Property predicate : defaultValueMap.keySet()) {
                if (newFocusNode.hasProperty(predicate)) continue;
                NodeExpression ne = NodeExpressionFactory.get().create((RDFNode)defaultValueMap.get(predicate));
                ne.eval((RDFNode)focusNode, this).forEachRemaining(v -> this.inferencesModel.add(focusNode, predicate, v));
            }
            return newFocusNode;
        }
        return focusNode;
    }

    public void addResultMessage(Resource result, Literal message, QuerySolution bindings) {
        result.addProperty(SH.resultMessage, (RDFNode)SPARQLSubstitutions.withSubstitutions(message, bindings, this.getLabelFunction()));
    }

    public Resource createResult(Resource type, Constraint constraint, RDFNode focusNode) {
        Resource result = this.report.getModel().createResource(type);
        this.report.addProperty(SH.result, (RDFNode)result);
        result.addProperty(SH.resultSeverity, (RDFNode)constraint.getSeverity());
        result.addProperty(SH.sourceConstraintComponent, (RDFNode)constraint.getComponent());
        result.addProperty(SH.sourceShape, (RDFNode)constraint.getShapeResource());
        if (focusNode != null) {
            result.addProperty(SH.focusNode, focusNode);
        }
        this.checkMaximumNumberFailures(constraint);
        ++this.resultsCount;
        return result;
    }

    public Resource createValidationResult(Constraint constraint, RDFNode focusNode, RDFNode value, Supplier<String> defaultMessage) {
        String m;
        Collection<RDFNode> messages;
        Resource result = this.createResult(SH.ValidationResult, constraint, focusNode);
        if (value != null) {
            result.addProperty(SH.value, value);
        }
        if (!constraint.getShape().isNodeShape()) {
            result.addProperty(SH.resultPath, (RDFNode)SHACLPaths.clonePath(constraint.getShapeResource().getPath(), result.getModel()));
        }
        if ((messages = constraint.getMessages()).size() > 0) {
            messages.stream().forEach(message -> result.addProperty(SH.resultMessage, message));
        } else if (defaultMessage != null && (m = defaultMessage.get()) != null) {
            result.addProperty(SH.resultMessage, m);
        }
        return result;
    }

    private void checkMaximumNumberFailures(Constraint constraint) {
        if (SH.Violation.equals((Object)constraint.getShape().getSeverity())) {
            ++this.violationsCount;
            if (this.configuration.getValidationErrorBatch() != -1 && this.violationsCount >= this.configuration.getValidationErrorBatch()) {
                throw new MaximumNumberViolations(this.violationsCount);
            }
        }
    }

    public ClassesCache getClassesCache() {
        return this.classesCache;
    }

    public ValidationEngineConfiguration getConfiguration() {
        return this.configuration;
    }

    public String getLabel(RDFNode node) {
        return this.labelsCache.computeIfAbsent(node, n -> this.getLabelFunction().apply((RDFNode)n));
    }

    public Function<RDFNode, String> getLabelFunction() {
        return this.labelFunction;
    }

    public ValidationProfile getProfile() {
        return this.profile;
    }

    public Resource getReport() {
        return this.report;
    }

    private Set<Resource> getShapesForNode(RDFNode focusNode, Dataset dataset, Model shapesModel) {
        HashSet<Resource> shapes = new HashSet<Resource>();
        for (Shape rootShape : this.shapesGraph.getRootShapes()) {
            for (Target target : rootShape.getTargets()) {
                if (target instanceof InstancesTarget || !target.contains(dataset, focusNode)) continue;
                shapes.add(rootShape.getShapeResource());
            }
        }
        if (focusNode instanceof Resource) {
            for (Resource type : JenaUtil.getAllTypes((Resource)focusNode)) {
                if (JenaUtil.hasIndirectType(type.inModel(shapesModel), SH.Shape)) {
                    shapes.add(type);
                }
                for (Statement s : shapesModel.listStatements(null, SH.targetClass, (RDFNode)type).toList()) {
                    shapes.add(s.getSubject());
                }
            }
        }
        return shapes;
    }

    public ValidationReport getValidationReport() {
        return new ResourceValidationReport(this.report);
    }

    public Collection<RDFNode> getValueNodes(Constraint constraint, RDFNode focusNode) {
        if (constraint.getShape().isNodeShape()) {
            return Collections.singletonList(focusNode);
        }
        ValueNodesCacheKey key = new ValueNodesCacheKey(focusNode, constraint.getShape().getPath());
        return this.valueNodes.computeIfAbsent(key, k -> this.getValueNodesHelper(focusNode, constraint));
    }

    private Collection<RDFNode> getValueNodesHelper(RDFNode focusNode, Constraint constraint) {
        Property predicate = constraint.getShape().getPredicate();
        if (predicate != null) {
            LinkedList<RDFNode> results = new LinkedList<RDFNode>();
            if (focusNode instanceof Resource) {
                StmtIterator it = ((Resource)focusNode).listProperties(predicate);
                while (it.hasNext()) {
                    results.add(((Statement)it.next()).getObject());
                }
            }
            return results;
        }
        Path jenaPath = constraint.getShape().getJenaPath();
        if (jenaPath instanceof P_Inverse && ((P_Inverse)jenaPath).getSubPath() instanceof P_Link) {
            LinkedList<RDFNode> results = new LinkedList<RDFNode>();
            Property inversePredicate = ResourceFactory.createProperty((String)((P_Link)((P_Inverse)jenaPath).getSubPath()).getNode().getURI());
            StmtIterator it = focusNode.getModel().listStatements(null, inversePredicate, focusNode);
            while (it.hasNext()) {
                results.add((RDFNode)((Statement)it.next()).getSubject());
            }
            return results;
        }
        HashSet<RDFNode> results = new HashSet<RDFNode>();
        Iterator it = PathEval.eval((Graph)focusNode.getModel().getGraph(), (Node)focusNode.asNode(), (Path)jenaPath, (Context)Context.emptyContext());
        while (it.hasNext()) {
            Node node = (Node)it.next();
            results.add(focusNode.getModel().asRDFNode(node));
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean nodesConformToShape(List<RDFNode> focusNodes, Node shape) {
        block11: {
            if (!this.shapesGraph.isIgnored(shape)) {
                Resource oldReport = this.report;
                this.report = JenaUtil.createMemoryModel().createResource();
                try {
                    Shape vs = this.shapesGraph.getShape(shape);
                    if (vs.isDeactivated()) break block11;
                    boolean nested = SHACLScriptEngineManager.get().begin();
                    try {
                        Iterator<Constraint> iterator = vs.getConstraints().iterator();
                        while (true) {
                            if (iterator.hasNext()) {
                                Constraint constraint = iterator.next();
                                this.validateNodesAgainstConstraint(focusNodes, constraint);
                                if (!this.report.hasProperty(SH.result)) continue;
                                boolean bl = false;
                                return bl;
                                continue;
                            }
                            break;
                        }
                    }
                    finally {
                        SHACLScriptEngineManager.get().end(nested);
                    }
                }
                finally {
                    this.report = oldReport;
                }
            }
        }
        return true;
    }

    public void setClassesCache(ClassesCache value) {
        this.classesCache = value;
    }

    public void setFocusNodeFilter(Predicate<RDFNode> value) {
        this.focusNodeFilter = value;
    }

    public void setLabelFunction(Function<RDFNode, String> value) {
        this.labelFunction = value;
    }

    public void updateConforms() {
        boolean conforms = true;
        StmtIterator it = this.report.listProperties(SH.result);
        while (it.hasNext()) {
            Statement s = (Statement)it.next();
            if (!s.getResource().hasProperty(RDF.type, (RDFNode)SH.ValidationResult)) continue;
            conforms = false;
            it.close();
            break;
        }
        if (this.report.hasProperty(SH.conforms)) {
            this.report.removeAll(SH.conforms);
        }
        this.report.addProperty(SH.conforms, (RDFNode)(conforms ? JenaDatatypes.TRUE : JenaDatatypes.FALSE));
    }

    public Resource validateAll() throws InterruptedException {
        List<Shape> rootShapes = this.shapesGraph.getRootShapes();
        return this.validateShapes(rootShapes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource validateNode(Node focusNode) throws InterruptedException {
        Model shapesModel = this.dataset.getNamedModel(this.shapesGraphURI.toString());
        RDFNode focusRDFNode = this.dataset.getDefaultModel().asRDFNode(focusNode);
        Set<Resource> shapes = this.getShapesForNode(focusRDFNode, this.dataset, shapesModel);
        boolean nested = SHACLScriptEngineManager.get().begin();
        try {
            for (Resource shape : shapes) {
                if (this.monitor != null && this.monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                this.validateNodesAgainstShape(Collections.singletonList(focusRDFNode), shape.asNode());
            }
        }
        finally {
            SHACLScriptEngineManager.get().end(nested);
        }
        return this.report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource validateNodesAgainstShape(List<RDFNode> focusNodes, Node shape) {
        Shape vs;
        if (!this.shapesGraph.isIgnored(shape) && !(vs = this.shapesGraph.getShape(shape)).isDeactivated()) {
            boolean nested = SHACLScriptEngineManager.get().begin();
            ValidationEngine oldEngine = current.get();
            current.set(this);
            try {
                for (Constraint constraint : vs.getConstraints()) {
                    this.validateNodesAgainstConstraint(focusNodes, constraint);
                }
            }
            finally {
                current.set(oldEngine);
                SHACLScriptEngineManager.get().end(nested);
            }
        }
        return this.report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource validateShapes(Collection<Shape> shapes) throws InterruptedException {
        boolean nested = SHACLScriptEngineManager.get().begin();
        try {
            if (this.monitor != null) {
                this.monitor.beginTask("Validating " + shapes.size() + " shapes", shapes.size());
            }
            if (this.classesCache == null) {
                this.classesCache = new ClassesCache();
            }
            int i = 0;
            for (Shape shape : shapes) {
                if (this.monitor != null) {
                    String label = "Shape " + ++i + ": " + this.getLabelFunction().apply((RDFNode)shape.getShapeResource());
                    if (this.resultsCount > 0) {
                        label = this.resultsCount + " results. " + label;
                    }
                    this.monitor.subTask(label);
                }
                Collection<RDFNode> focusNodes = shape.getTargetNodes(this.dataset);
                if (this.focusNodeFilter != null) {
                    LinkedList<RDFNode> filteredFocusNodes = new LinkedList<RDFNode>();
                    for (RDFNode focusNode : focusNodes) {
                        if (!this.focusNodeFilter.test(focusNode)) continue;
                        filteredFocusNodes.add(focusNode);
                    }
                    focusNodes = filteredFocusNodes;
                }
                if (!focusNodes.isEmpty()) {
                    for (Constraint constraint : shape.getConstraints()) {
                        this.validateNodesAgainstConstraint(focusNodes, constraint);
                    }
                }
                if (this.monitor == null) continue;
                this.monitor.worked(1);
                if (!this.monitor.isCanceled()) continue;
                throw new InterruptedException();
            }
        }
        catch (MaximumNumberViolations maximumNumberViolations) {
        }
        finally {
            SHACLScriptEngineManager.get().end(nested);
        }
        this.updateConforms();
        return this.report;
    }

    protected void validateNodesAgainstConstraint(Collection<RDFNode> focusNodes, Constraint constraint) {
        ConstraintExecutor executor;
        if (this.configuration != null && this.configuration.isSkippedConstraintComponent(constraint.getComponent())) {
            return;
        }
        try {
            executor = constraint.getExecutor();
        }
        catch (Exception ex) {
            Resource result = this.createResult(DASH.FailureResult, constraint, (RDFNode)constraint.getShapeResource());
            result.addProperty(SH.resultMessage, "Failed to create validator: " + ExceptionUtil.getDeepMessage(ex));
            return;
        }
        if (executor != null) {
            if (SHACLPreferences.isProduceFailuresMode()) {
                try {
                    executor.executeConstraint(constraint, this, focusNodes);
                }
                catch (Exception ex) {
                    Resource result = this.createResult(DASH.FailureResult, constraint, (RDFNode)constraint.getShapeResource());
                    result.addProperty(SH.resultMessage, "Exception during validation: " + ExceptionUtil.getDeepMessage(ex));
                }
            } else {
                executor.executeConstraint(constraint, this, focusNodes);
            }
        } else {
            FailureLog.get().logWarning("No suitable validator found for constraint " + constraint);
        }
    }

    public void setConfiguration(ValidationEngineConfiguration configuration) {
        this.configuration = configuration;
        if (!configuration.getValidateShapes()) {
            this.shapesGraph.setShapeFilter(new ExcludeMetaShapesFilter());
        }
    }

    public void setProfile(ValidationProfile profile) {
        this.profile = profile;
    }

    private static class ValueNodesCacheKey {
        Resource path;
        RDFNode focusNode;

        ValueNodesCacheKey(RDFNode focusNode, Resource path) {
            this.path = path;
            this.focusNode = focusNode;
        }

        public boolean equals(Object o) {
            if (o instanceof ValueNodesCacheKey) {
                return this.path.equals((Object)((ValueNodesCacheKey)o).path) && this.focusNode.equals(((ValueNodesCacheKey)o).focusNode);
            }
            return false;
        }

        public int hashCode() {
            return this.path.hashCode() + this.focusNode.hashCode();
        }

        public String toString() {
            return this.focusNode.toString() + " . " + this.path;
        }
    }
}

