/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.validation.java;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.jena.rdf.model.Resource;
import org.topbraid.shacl.engine.Constraint;
import org.topbraid.shacl.validation.ConstraintExecutor;
import org.topbraid.shacl.validation.ConstraintExecutors;
import org.topbraid.shacl.validation.java.AndConstraintExecutor;
import org.topbraid.shacl.validation.java.ClassConstraintExecutor;
import org.topbraid.shacl.validation.java.ClosedConstraintExecutor;
import org.topbraid.shacl.validation.java.DatatypeConstraintExecutor;
import org.topbraid.shacl.validation.java.DisjointConstraintExecutor;
import org.topbraid.shacl.validation.java.EqualsConstraintExecutor;
import org.topbraid.shacl.validation.java.HasValueConstraintExecutor;
import org.topbraid.shacl.validation.java.InConstraintExecutor;
import org.topbraid.shacl.validation.java.LanguageInConstraintExecutor;
import org.topbraid.shacl.validation.java.LessThanConstraintExecutor;
import org.topbraid.shacl.validation.java.LessThanOrEqualsConstraintExecutor;
import org.topbraid.shacl.validation.java.MaxCountConstraintExecutor;
import org.topbraid.shacl.validation.java.MaxExclusiveConstraintExecutor;
import org.topbraid.shacl.validation.java.MaxInclusiveConstraintExecutor;
import org.topbraid.shacl.validation.java.MaxLengthConstraintExecutor;
import org.topbraid.shacl.validation.java.MinCountConstraintExecutor;
import org.topbraid.shacl.validation.java.MinExclusiveConstraintExecutor;
import org.topbraid.shacl.validation.java.MinInclusiveConstraintExecutor;
import org.topbraid.shacl.validation.java.MinLengthConstraintExecutor;
import org.topbraid.shacl.validation.java.NodeConstraintExecutor;
import org.topbraid.shacl.validation.java.NodeKindConstraintExecutor;
import org.topbraid.shacl.validation.java.NotConstraintExecutor;
import org.topbraid.shacl.validation.java.OrConstraintExecutor;
import org.topbraid.shacl.validation.java.PatternConstraintExecutor;
import org.topbraid.shacl.validation.java.QualifiedValueShapeConstraintExecutor;
import org.topbraid.shacl.validation.java.SingleLineConstraintExecutor;
import org.topbraid.shacl.validation.java.UniqueLangConstraintExecutor;
import org.topbraid.shacl.validation.java.XoneConstraintExecutor;
import org.topbraid.shacl.vocabulary.DASH;
import org.topbraid.shacl.vocabulary.SH;

public class JavaConstraintExecutors {
    private static Map<Resource, Function<Constraint, ConstraintExecutor>> map = new HashMap<Resource, Function<Constraint, ConstraintExecutor>>();

    public static void install(ConstraintExecutors constraintExecutors) {
        for (Resource cc : map.keySet()) {
            constraintExecutors.addSpecialExecutor(cc, map.get(cc));
        }
    }

    static {
        map.put(SH.AndConstraintComponent, constraint -> new AndConstraintExecutor((Constraint)constraint));
        map.put(SH.ClassConstraintComponent, constraint -> new ClassConstraintExecutor());
        map.put(SH.ClosedConstraintComponent, constraint -> new ClosedConstraintExecutor((Constraint)constraint));
        map.put(SH.DatatypeConstraintComponent, constraint -> new DatatypeConstraintExecutor());
        map.put(SH.DisjointConstraintComponent, constraint -> new DisjointConstraintExecutor());
        map.put(SH.EqualsConstraintComponent, constraint -> new EqualsConstraintExecutor());
        map.put(SH.HasValueConstraintComponent, constraint -> new HasValueConstraintExecutor());
        map.put(SH.InConstraintComponent, constraint -> new InConstraintExecutor((Constraint)constraint));
        map.put(SH.LanguageInConstraintComponent, constraint -> new LanguageInConstraintExecutor((Constraint)constraint));
        map.put(SH.LessThanConstraintComponent, constraint -> new LessThanConstraintExecutor());
        map.put(SH.LessThanOrEqualsConstraintComponent, constraint -> new LessThanOrEqualsConstraintExecutor());
        map.put(SH.MaxCountConstraintComponent, constraint -> new MaxCountConstraintExecutor((Constraint)constraint));
        map.put(SH.MaxExclusiveConstraintComponent, constraint -> new MaxExclusiveConstraintExecutor());
        map.put(SH.MaxInclusiveConstraintComponent, constraint -> new MaxInclusiveConstraintExecutor());
        map.put(SH.MaxLengthConstraintComponent, constraint -> new MaxLengthConstraintExecutor((Constraint)constraint));
        map.put(SH.MinCountConstraintComponent, constraint -> new MinCountConstraintExecutor((Constraint)constraint));
        map.put(SH.MinExclusiveConstraintComponent, constraint -> new MinExclusiveConstraintExecutor());
        map.put(SH.MinInclusiveConstraintComponent, constraint -> new MinInclusiveConstraintExecutor());
        map.put(SH.MinLengthConstraintComponent, constraint -> new MinLengthConstraintExecutor((Constraint)constraint));
        map.put(SH.NodeConstraintComponent, constraint -> new NodeConstraintExecutor());
        map.put(SH.NodeKindConstraintComponent, constraint -> new NodeKindConstraintExecutor());
        map.put(SH.NotConstraintComponent, constraint -> new NotConstraintExecutor());
        map.put(SH.OrConstraintComponent, constraint -> new OrConstraintExecutor((Constraint)constraint));
        map.put(SH.PatternConstraintComponent, constraint -> new PatternConstraintExecutor((Constraint)constraint));
        map.put(SH.QualifiedMaxCountConstraintComponent, constraint -> new QualifiedValueShapeConstraintExecutor((Constraint)constraint));
        map.put(SH.QualifiedMinCountConstraintComponent, constraint -> new QualifiedValueShapeConstraintExecutor((Constraint)constraint));
        map.put(SH.UniqueLangConstraintComponent, constraint -> new UniqueLangConstraintExecutor());
        map.put(SH.XoneConstraintComponent, constraint -> new XoneConstraintExecutor((Constraint)constraint));
        map.put(DASH.SingleLineConstraintComponent, constraint -> new SingleLineConstraintExecutor());
    }
}

