/*
 * Copyright (c) 2024 Torqware LLC. All rights reserved.
 *
 * You should have received a copy of the Torq Lang License v1.0 along with this program.
 * If not, see <http://torq-lang.github.io/licensing/torq-lang-license-v1_0>.
 */

package org.torqlang.klvm;

/*
 * When an implementation inherits from CompleteObj, it is inheriting:
 *     - entails from Value, which compares on identity using `==`
 *     - equals from Object, which compares on identity using `==`
 *     - hashCode from Object, which is a native method returning system identity
 *     - isValidKey from CompleteObj, which returns true
 */
public interface CompleteObj extends Complete, Obj {

    @Override
    CompleteField fieldAt(int index);

    @Override
    default boolean isValidKey() {
        return true;
    }

    @Override
    CompleteProc valueAt(int index);
}
