/*
 * Copyright (c) 2024 Torqware LLC. All rights reserved.
 *
 * You should have received a copy of the Torq Lang License v1.0 along with this program.
 * If not, see <http://torq-lang.github.io/licensing/torq-lang-license-v1_0>.
 */

package org.torqlang.klvm;

import org.torqlang.util.SourceSpan;

import java.util.List;
import java.util.Set;

import static org.torqlang.util.ListTools.nullSafeCopyOf;

public final class TupleDef implements Decl {

    public final LiteralOrIdent label;
    public final List<ValueDef> valueDefs;
    public final SourceSpan sourceSpan;

    public TupleDef(LiteralOrIdent label, List<ValueDef> valueDefs, SourceSpan sourceSpan) {
        this.label = label;
        this.valueDefs = nullSafeCopyOf(valueDefs);
        this.sourceSpan = sourceSpan;
    }

    @Override
    public final <T, R> R accept(KernelVisitor<T, R> visitor, T state) {
        return visitor.visitTupleDef(this, state);
    }

    @Override
    public final void captureLexicallyFree(Set<Ident> knownBound, Set<Ident> lexicallyFree) {
        for (ValueDef vd : valueDefs) {
            vd.captureLexicallyFree(knownBound, lexicallyFree);
        }
    }

    @Override
    public final String toString() {
        return toKernelString();
    }

    public final int valueCount() {
        return valueDefs.size();
    }

    public final ValueDef valueDefAtIndex(int i) {
        return valueDefs.get(i);
    }

}
