/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.klvm;

import java.util.List;
import org.torqlang.klvm.Closure;
import org.torqlang.klvm.CompleteOrIdent;
import org.torqlang.klvm.Env;
import org.torqlang.klvm.EnvEntry;
import org.torqlang.klvm.InvalidArgCountError;
import org.torqlang.klvm.KernelVisitor;
import org.torqlang.klvm.Machine;
import org.torqlang.klvm.ProcDef;
import org.torqlang.klvm.WaitException;
import org.torqlang.util.SourceSpan;

public abstract class AbstractClosure
implements Closure {
    ProcDef procDef;
    Env capturedEnv;

    AbstractClosure(ProcDef procDef, Env capturedEnv) {
        this.capturedEnv = capturedEnv;
        this.procDef = procDef;
    }

    @Override
    public final <T, R> R accept(KernelVisitor<T, R> visitor, T state) {
        return visitor.visitClosure(this, state);
    }

    @Override
    public final void apply(List<CompleteOrIdent> ys, Env env, Machine machine) throws WaitException {
        Env bodyEnv;
        if (ys.size() != this.procDef.xs.size()) {
            throw new InvalidArgCountError(this.procDef.xs.size(), ys, this);
        }
        if (!ys.isEmpty()) {
            EnvEntry[] args = new EnvEntry[ys.size()];
            for (int i = 0; i < ys.size(); ++i) {
                args[i] = new EnvEntry(this.procDef.xs.get(i), ys.get(i).toVar(env));
            }
            bodyEnv = Env.createPrivatelyForKlvm(this.capturedEnv, args);
        } else {
            bodyEnv = this.capturedEnv;
        }
        machine.pushStackEntry(this.procDef.instr, bodyEnv);
    }

    @Override
    public final Env capturedEnv() {
        return this.capturedEnv;
    }

    @Override
    public final boolean isValidKey() {
        return true;
    }

    @Override
    public final ProcDef procDef() {
        return this.procDef;
    }

    final void restore(ProcDef procDef, Env capturedEnv) {
        this.procDef = procDef;
        this.capturedEnv = capturedEnv;
    }

    @Override
    public final SourceSpan sourceSpan() {
        return this.procDef.sourceSpan;
    }

    public final String toString() {
        return this.toKernelString();
    }
}

