/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.klvm;

import java.util.Arrays;
import org.torqlang.klvm.Complete;
import org.torqlang.klvm.CompleteField;
import org.torqlang.klvm.CompleteRec;
import org.torqlang.klvm.DuplicateFeatureError;
import org.torqlang.klvm.Feature;
import org.torqlang.klvm.FeatureNotFoundError;
import org.torqlang.klvm.FeatureProviderComparator;
import org.torqlang.klvm.Literal;
import org.torqlang.klvm.Rec;
import org.torqlang.klvm.ValueOrVar;
import org.torqlang.util.BinarySearchTools;

public abstract class AbstractCompleteRec
implements CompleteRec {
    private CompleteField[] completeFields;
    private Literal label;
    private int hashCode;
    private boolean hashCodeIsZero;

    private int binarySearchFields(Feature feature) {
        return BinarySearchTools.search((Object[])this.completeFields, f -> FEATURE_COMPARATOR.compare(feature, f.feature));
    }

    private void checkForDuplicateFeatures() {
        CompleteField prev = null;
        for (CompleteField f : this.completeFields) {
            if (prev != null && FeatureProviderComparator.SINGLETON.compare(prev, f) == 0) {
                throw new DuplicateFeatureError(this, f.feature);
            }
            prev = f;
        }
    }

    public final boolean equals(Object other) {
        return this.equalsComplete(other);
    }

    @Override
    public final Feature featureAt(int i) {
        return this.completeFields[i].feature;
    }

    @Override
    public final CompleteField fieldAt(int index) {
        return this.completeFields[index];
    }

    @Override
    public final int fieldCount() {
        return this.completeFields.length;
    }

    private CompleteField findField(Feature feature) {
        int index = this.binarySearchFields(feature);
        return index > -1 ? this.completeFields[index] : null;
    }

    @Override
    public final Complete findValue(Feature feature) {
        CompleteField f = this.findField(feature);
        return f == null ? null : f.value;
    }

    public final int hashCode() {
        int h = this.hashCode;
        if (h == 0 && !this.hashCodeIsZero) {
            h = this.hashCodeComplete(null);
            if (h == 0) {
                this.hashCodeIsZero = true;
            } else {
                this.hashCode = h;
            }
        }
        return h;
    }

    @Override
    public final boolean isValidKey() {
        return true;
    }

    @Override
    public final Literal label() {
        return this.label;
    }

    void restore(Literal label, CompleteField[] completeFields) {
        this.label = label == null ? Rec.DEFAULT_LABEL : label;
        this.completeFields = completeFields;
        Arrays.sort(completeFields, FeatureProviderComparator.comparator());
        this.checkForDuplicateFeatures();
    }

    @Override
    public final Complete select(Feature feature) {
        Complete result = this.findValue(feature);
        if (result == null) {
            throw new FeatureNotFoundError(this, feature);
        }
        return result;
    }

    @Override
    public final void setUnifiedValue(int index, ValueOrVar unifiedValueOrVar) {
        CompleteField currentField = this.completeFields[index];
        if (currentField.value != unifiedValueOrVar) {
            this.completeFields[index] = new CompleteField(currentField.feature, (Complete)unifiedValueOrVar);
        }
    }

    public final String toString() {
        return this.toKernelString();
    }

    @Override
    public final Complete valueAt(int i) {
        return this.completeFields[i].value;
    }
}

