/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.klvm;

import java.util.Collection;
import java.util.Collections;
import org.torqlang.klvm.AbstractTuple;
import org.torqlang.klvm.Complete;
import org.torqlang.klvm.CompleteField;
import org.torqlang.klvm.CompleteTuple;
import org.torqlang.klvm.Feature;
import org.torqlang.klvm.Int32;
import org.torqlang.klvm.Int64;
import org.torqlang.klvm.Literal;
import org.torqlang.klvm.Rec;
import org.torqlang.klvm.ValueOrVar;

public abstract class AbstractCompleteTuple
extends AbstractTuple
implements CompleteTuple {
    private Literal label;
    private Complete[] values;
    private int hashCode;
    private boolean hashCodeIsZero;

    @Override
    public final void addAllTo(Collection<? super Complete> collection) {
        Collections.addAll(collection, this.values);
    }

    public final boolean equals(Object other) {
        return this.equalsComplete(other);
    }

    @Override
    public final CompleteField fieldAt(int index) {
        return new CompleteField(Int32.of(index), this.values[index]);
    }

    @Override
    public final int fieldCount() {
        return this.values.length;
    }

    @Override
    public final Complete findValue(Feature feature) {
        if (!(feature instanceof Int64)) {
            return null;
        }
        Int64 int64 = (Int64)feature;
        int index = int64.intValue();
        return index > -1 && index < this.values.length ? this.values[index] : null;
    }

    public final int hashCode() {
        int h = this.hashCode;
        if (h == 0 && !this.hashCodeIsZero) {
            h = this.hashCodeComplete(null);
            if (h == 0) {
                this.hashCodeIsZero = true;
            } else {
                this.hashCode = h;
            }
        }
        return h;
    }

    @Override
    public final boolean isValidKey() {
        return true;
    }

    @Override
    public final Literal label() {
        return this.label;
    }

    void restore(Literal label, Complete[] values) {
        this.label = label == null ? Rec.DEFAULT_LABEL : label;
        this.values = values;
    }

    @Override
    public final Complete select(Feature feature) {
        return this.valueAt(this.featureToIndex(feature, this.values.length));
    }

    @Override
    public final void setUnifiedValue(int index, ValueOrVar unifiedValueOrVar) {
        Complete currentValue = this.values[index];
        if (currentValue != unifiedValueOrVar) {
            this.values[index] = (Complete)unifiedValueOrVar;
        }
    }

    @Override
    public final Complete valueAt(int i) {
        return this.values[i];
    }
}

