/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.klvm;

import java.util.Collection;
import java.util.List;
import org.torqlang.klvm.CompleteOrIdent;
import org.torqlang.klvm.Env;
import org.torqlang.klvm.Eof;
import org.torqlang.klvm.InvalidArgCountError;
import org.torqlang.klvm.Machine;
import org.torqlang.klvm.PartialProc;
import org.torqlang.klvm.ValueOrVar;
import org.torqlang.klvm.WaitException;

public abstract class AbstractIter
implements PartialProc {
    private static final int EXPECTED_ARG_COUNT = 1;
    private final List<ValueOrVar> elems;
    private int nextIndex;

    public AbstractIter(Collection<? extends ValueOrVar> elems) {
        this.elems = List.copyOf(elems);
        this.nextIndex = 0;
    }

    @Override
    public void apply(List<CompleteOrIdent> ys, Env env, Machine machine) throws WaitException {
        ValueOrVar next;
        if (ys.size() != 1) {
            throw new InvalidArgCountError(1, ys, this);
        }
        int size = this.elems.size();
        if (this.nextIndex < size) {
            next = this.elems.get(this.nextIndex);
            ++this.nextIndex;
        } else {
            next = Eof.SINGLETON;
        }
        ValueOrVar target = ys.get(0).resolveValueOrVar(env);
        target.bindToValueOrVar(next, null);
    }
}

