/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.klvm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import org.torqlang.klvm.BasicCompleteRec;
import org.torqlang.klvm.Complete;
import org.torqlang.klvm.CompleteField;
import org.torqlang.klvm.CompleteRec;
import org.torqlang.klvm.DuplicateFeatureError;
import org.torqlang.klvm.Feature;
import org.torqlang.klvm.FeatureNotFoundError;
import org.torqlang.klvm.FeatureProviderComparator;
import org.torqlang.klvm.FutureField;
import org.torqlang.klvm.Literal;
import org.torqlang.klvm.LiteralOrVar;
import org.torqlang.klvm.Partial;
import org.torqlang.klvm.PartialField;
import org.torqlang.klvm.PartialRec;
import org.torqlang.klvm.Rec;
import org.torqlang.klvm.Value;
import org.torqlang.klvm.ValueOrVar;
import org.torqlang.klvm.Var;
import org.torqlang.klvm.WaitException;
import org.torqlang.klvm.WaitVarException;
import org.torqlang.util.BinarySearchTools;

final class BasicPartialRec
implements PartialRec {
    private final List<FutureField> futureFields;
    private final List<PartialField> partialFields;
    private final int totalFieldCount;
    private Var futureLabel;
    private Literal label;

    private BasicPartialRec(LiteralOrVar literalOrVar, List<FutureField> futureFields, List<PartialField> partialFields) {
        if (literalOrVar == null) {
            this.label = Rec.DEFAULT_LABEL;
        } else if (literalOrVar instanceof Literal) {
            Literal literal;
            this.label = literal = (Literal)literalOrVar;
        } else {
            this.futureLabel = (Var)literalOrVar;
        }
        this.futureFields = futureFields;
        this.partialFields = partialFields;
        this.totalFieldCount = futureFields.size() + partialFields.size();
        if (futureFields.isEmpty()) {
            partialFields.sort(FeatureProviderComparator.comparator());
        }
        this.sweepUndeterminedVars();
        this.checkForDuplicateFeatures();
    }

    static BasicPartialRec createPrivatelyForKlvm(LiteralOrVar label, List<FutureField> futureFields, List<PartialField> partialFields) {
        return new BasicPartialRec(label, futureFields, partialFields);
    }

    private int binarySearchFields(Feature feature) {
        return BinarySearchTools.search(this.partialFields, f -> FEATURE_COMPARATOR.compare(feature, f.feature));
    }

    @Override
    public final CompleteRec checkComplete() throws WaitVarException {
        return this.checkComplete(new IdentityHashMap());
    }

    @Override
    public final CompleteRec checkComplete(IdentityHashMap<Partial, Complete> memos) throws WaitVarException {
        Complete previous = memos.get(this);
        if (previous != null) {
            return (CompleteRec)previous;
        }
        this.checkDetermined();
        BasicCompleteRec thisCompleteRec = BasicCompleteRec.instanceForRestore();
        memos.put(this, thisCompleteRec);
        CompleteField[] thisCompleteFields = new CompleteField[this.partialFields.size()];
        for (int i = 0; i < this.partialFields.size(); ++i) {
            CompleteField completeField;
            Complete completeValue;
            PartialField partialField = this.partialFields.get(i);
            Value value = partialField.value.resolveValue();
            if (value instanceof Partial) {
                Partial partial = (Partial)value;
                completeValue = partial.checkComplete(memos);
            } else {
                completeValue = value.checkComplete();
            }
            thisCompleteFields[i] = completeField = new CompleteField(partialField.feature, completeValue);
        }
        thisCompleteRec.restore(this.label, thisCompleteFields);
        return thisCompleteRec;
    }

    private void checkForDuplicateFeatures() {
        PartialField prev = null;
        for (PartialField f : this.partialFields) {
            if (prev != null && FeatureProviderComparator.SINGLETON.compare(prev, f) == 0) {
                throw new DuplicateFeatureError(this, f.feature);
            }
            prev = f;
        }
    }

    @Override
    public final Feature featureAt(int i) {
        return this.partialFields.get((int)i).feature;
    }

    @Override
    public final PartialField fieldAt(int index) {
        return this.partialFields.get(index);
    }

    @Override
    public final int fieldCount() {
        return this.partialFields.size();
    }

    private PartialField findField(Feature feature) {
        int index = this.binarySearchFields(feature);
        return index > -1 ? this.partialFields.get(index) : null;
    }

    @Override
    public final ValueOrVar findValue(Feature feature) {
        PartialField f = this.findField(feature);
        return f == null ? null : f.value;
    }

    @Override
    public final int futureFieldCount() {
        return this.futureFields.size();
    }

    @Override
    public final Var futureLabel() {
        return this.futureLabel;
    }

    @Override
    public final Literal label() {
        return this.label;
    }

    @Override
    public final ValueOrVar select(Feature feature) throws WaitException {
        this.checkDetermined();
        ValueOrVar result = this.findValue(feature);
        if (result == null) {
            throw new FeatureNotFoundError(this, feature);
        }
        return result;
    }

    @Override
    public final void setUnifiedValue(int index, ValueOrVar unifiedValueOrVar) {
        PartialField currentField = this.partialFields.get(index);
        if (currentField.value != unifiedValueOrVar) {
            this.partialFields.set(index, new PartialField(currentField.feature, unifiedValueOrVar));
        }
    }

    @Override
    public final Collection<Var> sweepUndeterminedVars() {
        if (this.label != null && this.futureFields.isEmpty()) {
            return EMPTY_VAR_COLLECTION;
        }
        ArrayList<Var> answer = new ArrayList<Var>(this.futureFields.size() + 1);
        if (this.label == null) {
            ValueOrVar labelRes = this.futureLabel.resolveValueOrVar();
            if (labelRes instanceof Literal) {
                Literal literal;
                this.label = literal = (Literal)labelRes;
                this.futureLabel = null;
            } else {
                answer.add((Var)labelRes);
            }
        }
        if (!this.futureFields.isEmpty()) {
            ArrayList<FutureField> nowDetermined = new ArrayList<FutureField>(this.futureFields.size());
            for (FutureField ff : this.futureFields) {
                ValueOrVar featureRes = ff.feature.resolveValueOrVar();
                if (featureRes instanceof Feature) {
                    Feature feature = (Feature)featureRes;
                    ValueOrVar valueRes = ff.value.resolveValueOrVar();
                    this.partialFields.add(new PartialField(feature, valueRes));
                    nowDetermined.add(ff);
                    continue;
                }
                answer.add((Var)featureRes);
            }
            this.futureFields.removeAll(nowDetermined);
            if (this.futureFields.isEmpty()) {
                this.partialFields.sort(FeatureProviderComparator.comparator());
                this.checkForDuplicateFeatures();
            }
        }
        return answer;
    }

    public final String toString() {
        return this.toKernelString();
    }

    @Override
    public final int totalFieldCount() {
        return this.totalFieldCount;
    }

    @Override
    public final int unificationPriority() {
        return 100;
    }

    @Override
    public final ValueOrVar valueAt(int i) {
        return this.partialFields.get((int)i).value;
    }
}

