/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.klvm;

import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import org.torqlang.klvm.AbstractTuple;
import org.torqlang.klvm.BasicCompleteTuple;
import org.torqlang.klvm.Complete;
import org.torqlang.klvm.CompleteTuple;
import org.torqlang.klvm.Feature;
import org.torqlang.klvm.Int32;
import org.torqlang.klvm.Int64;
import org.torqlang.klvm.Literal;
import org.torqlang.klvm.LiteralOrVar;
import org.torqlang.klvm.Partial;
import org.torqlang.klvm.PartialField;
import org.torqlang.klvm.PartialTuple;
import org.torqlang.klvm.Rec;
import org.torqlang.klvm.Value;
import org.torqlang.klvm.ValueOrVar;
import org.torqlang.klvm.Var;
import org.torqlang.klvm.WaitVarException;

final class BasicPartialTuple
extends AbstractTuple
implements PartialTuple {
    private final ValueOrVar[] values;
    private Var futureLabel;
    private Literal label;

    private BasicPartialTuple(LiteralOrVar literalOrVar, ValueOrVar[] values) {
        if (literalOrVar == null) {
            this.label = Rec.DEFAULT_LABEL;
        } else if (literalOrVar instanceof Literal) {
            Literal literal;
            this.label = literal = (Literal)literalOrVar;
        } else {
            this.futureLabel = (Var)literalOrVar;
        }
        this.values = values;
        this.sweepUndeterminedVars();
    }

    static BasicPartialTuple createPrivatelyForKlvm(LiteralOrVar label, ValueOrVar[] values) {
        return new BasicPartialTuple(label, values);
    }

    @Override
    public final CompleteTuple checkComplete() throws WaitVarException {
        return this.checkComplete(new IdentityHashMap());
    }

    @Override
    public final CompleteTuple checkComplete(IdentityHashMap<Partial, Complete> memos) throws WaitVarException {
        Complete previous = memos.get(this);
        if (previous != null) {
            return (CompleteTuple)previous;
        }
        this.sweepUndeterminedVars();
        BasicCompleteTuple thisCompleteTuple = BasicCompleteTuple.instanceForRestore();
        memos.put(this, thisCompleteTuple);
        Complete[] completeValues = new Complete[this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            Complete completeValue;
            ValueOrVar valueOrVar = this.values[i];
            Value value = valueOrVar.resolveValue();
            if (value instanceof Partial) {
                Partial partial = (Partial)value;
                completeValue = partial.checkComplete(memos);
            } else {
                completeValue = value.checkComplete();
            }
            completeValues[i] = completeValue;
        }
        thisCompleteTuple.restore(this.label, completeValues);
        return thisCompleteTuple;
    }

    @Override
    public final PartialField fieldAt(int index) {
        return new PartialField(Int32.of(index), this.values[index]);
    }

    @Override
    public final int fieldCount() {
        return this.values.length;
    }

    @Override
    public final ValueOrVar findValue(Feature feature) {
        if (!(feature instanceof Int64)) {
            return null;
        }
        Int64 int64 = (Int64)feature;
        int index = int64.intValue();
        return index > -1 && index < this.values.length ? this.values[index] : null;
    }

    @Override
    public final int futureFieldCount() {
        return 0;
    }

    @Override
    public final Var futureLabel() {
        return this.futureLabel;
    }

    @Override
    public final Literal label() {
        return this.label;
    }

    @Override
    public final ValueOrVar select(Feature feature) {
        return this.valueAt(this.featureToIndex(feature, this.values.length));
    }

    @Override
    public final void setUnifiedValue(int index, ValueOrVar unifiedValueOrVar) {
        this.values[index] = unifiedValueOrVar;
    }

    @Override
    public final Collection<Var> sweepUndeterminedVars() {
        if (this.label != null) {
            return EMPTY_VAR_COLLECTION;
        }
        ValueOrVar labelRes = this.futureLabel.resolveValueOrVar();
        if (labelRes instanceof Literal) {
            Literal literal;
            this.label = literal = (Literal)labelRes;
            this.futureLabel = null;
            return EMPTY_VAR_COLLECTION;
        }
        return Collections.singleton((Var)labelRes);
    }

    @Override
    public final int totalFieldCount() {
        return this.fieldCount();
    }

    @Override
    public final int unificationPriority() {
        return 200;
    }

    @Override
    public final ValueOrVar valueAt(int i) {
        return this.values[i];
    }
}

