/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.klvm;

import java.util.ArrayList;
import java.util.List;
import org.torqlang.klvm.Env;
import org.torqlang.klvm.Feature;
import org.torqlang.klvm.FeatureProviderComparator;
import org.torqlang.klvm.FieldPtn;
import org.torqlang.klvm.Literal;
import org.torqlang.klvm.LiteralOrIdentPtn;
import org.torqlang.klvm.Rec;
import org.torqlang.klvm.RecPtn;
import org.torqlang.klvm.ResolvedFieldPtn;
import org.torqlang.klvm.ResolvedRecPtn;
import org.torqlang.klvm.Value;
import org.torqlang.klvm.ValueOrIdent;
import org.torqlang.klvm.ValueOrResolvedPtn;
import org.torqlang.klvm.ValueOrVar;
import org.torqlang.klvm.WaitException;
import org.torqlang.util.ListTools;
import org.torqlang.util.SourceSpan;

public final class BasicRecPtn
implements RecPtn {
    private final LiteralOrIdentPtn label;
    private final List<FieldPtn> fields;
    private final boolean partialArity;
    private final SourceSpan sourceSpan;

    public BasicRecPtn(LiteralOrIdentPtn label, List<FieldPtn> fields, boolean partialArity, SourceSpan sourceSpan) {
        this.label = label;
        this.fields = ListTools.nullSafeCopyOf(fields);
        this.partialArity = partialArity;
        this.sourceSpan = sourceSpan;
    }

    private static ValueOrResolvedPtn caseRecOfResolvedRecPtn(Rec rec, ResolvedRecPtn resRecPtn, Env env) throws WaitException {
        Value ptnLabel;
        if (resRecPtn.partialArity ? rec.fieldCount() < resRecPtn.fieldCount() : rec.fieldCount() != resRecPtn.fieldCount()) {
            return null;
        }
        Literal recLabel = rec.label();
        if (!recLabel.entailsValueOrIdent(ptnLabel = resRecPtn.label, env)) {
            return null;
        }
        int j = 0;
        for (int i = 0; i < resRecPtn.fieldCount(); ++i) {
            Value value;
            ValueOrVar recValue;
            ResolvedFieldPtn ptnField = resRecPtn.fields.get(i);
            Feature ptnFeature = ptnField.feature;
            while (true) {
                if (j >= rec.fieldCount()) {
                    return null;
                }
                Feature recFeature = rec.featureAt(j);
                recValue = rec.valueAt(j);
                if (recFeature.entailsValueOrIdent(ptnFeature, env)) break;
                if (!resRecPtn.partialArity) {
                    return null;
                }
                ++j;
            }
            ValueOrIdent valueOrIdent = ptnField.value;
            if (valueOrIdent instanceof Value && !recValue.entails(value = (Value)valueOrIdent, null)) {
                return null;
            }
            ++j;
        }
        return resRecPtn;
    }

    @Override
    public final ValueOrResolvedPtn caseRecOfThis(Rec rec, Env env) throws WaitException {
        rec.checkDetermined();
        Value labelRes = this.label.resolveValue(env);
        ArrayList<ResolvedFieldPtn> fieldsRes = new ArrayList<ResolvedFieldPtn>();
        for (FieldPtn fp : this.fields) {
            Feature featureRes = (Feature)fp.feature.resolveValue(env);
            ValueOrIdent valueRes = fp.value.resolveValueOrIdent(env);
            fieldsRes.add(new ResolvedFieldPtn(featureRes, valueRes));
        }
        fieldsRes.sort(FeatureProviderComparator.SINGLETON);
        ResolvedRecPtn resolvedRecPtn = new ResolvedRecPtn(labelRes, fieldsRes, this.partialArity);
        return BasicRecPtn.caseRecOfResolvedRecPtn(rec, resolvedRecPtn, env);
    }

    @Override
    public final List<FieldPtn> fields() {
        return this.fields;
    }

    @Override
    public final LiteralOrIdentPtn label() {
        return this.label;
    }

    @Override
    public final boolean partialArity() {
        return this.partialArity;
    }

    @Override
    public final SourceSpan sourceSpan() {
        return this.sourceSpan;
    }

    public final String toString() {
        return this.toKernelString();
    }
}

