/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.klvm;

import org.torqlang.klvm.CompleteField;
import org.torqlang.klvm.CompleteProc;
import org.torqlang.klvm.Feature;
import org.torqlang.klvm.KernelVisitor;
import org.torqlang.klvm.Literal;
import org.torqlang.klvm.Null;
import org.torqlang.klvm.Value;

public final class Bool
implements Literal {
    public static final Bool FALSE = new Bool(false);
    public static final Bool TRUE = new Bool(true);
    public final boolean value;

    private Bool(boolean value) {
        this.value = value;
    }

    public static Bool of(boolean value) {
        return value ? TRUE : FALSE;
    }

    @Override
    public final <T, R> R accept(KernelVisitor<T, R> visitor, T state) {
        return visitor.visitScalar(this, state);
    }

    @Override
    public final String appendToString(String string) {
        return string + this.value;
    }

    public final boolean equals(Object other) {
        return this.value && other == TRUE || !this.value && other == FALSE;
    }

    @Override
    public final Feature featureAt(int index) {
        throw new IndexOutOfBoundsException(Integer.toString(index));
    }

    @Override
    public final CompleteField fieldAt(int index) {
        throw new IndexOutOfBoundsException(Integer.toString(index));
    }

    @Override
    public final int fieldCount() {
        return 0;
    }

    @Override
    public final String formatAsKernelString() {
        return this.value ? "true" : "false";
    }

    @Override
    public final Bool greaterThan(Value right) {
        if (!(right instanceof Bool)) {
            throw new IllegalArgumentException("Argument must be a Bool");
        }
        Bool b = (Bool)right;
        return Bool.of(Boolean.compare(this.value, b.value) > 0);
    }

    @Override
    public final Bool greaterThanOrEqualTo(Value right) {
        if (!(right instanceof Bool)) {
            throw new IllegalArgumentException("Argument must be a Bool");
        }
        Bool b = (Bool)right;
        return Bool.of(Boolean.compare(this.value, b.value) >= 0);
    }

    public final int hashCode() {
        return Boolean.hashCode(this.value);
    }

    @Override
    public final Literal label() {
        return Null.SINGLETON;
    }

    @Override
    public final Bool lessThan(Value right) {
        if (!(right instanceof Bool)) {
            throw new IllegalArgumentException("Argument must be a Bool");
        }
        Bool b = (Bool)right;
        return Bool.of(Boolean.compare(this.value, b.value) < 0);
    }

    @Override
    public final Bool lessThanOrEqualTo(Value right) {
        if (!(right instanceof Bool)) {
            throw new IllegalArgumentException("Argument must be a Bool");
        }
        Bool b = (Bool)right;
        return Bool.of(Boolean.compare(this.value, b.value) <= 0);
    }

    @Override
    public final Bool not() {
        return this.value ? FALSE : TRUE;
    }

    @Override
    public final Boolean toNativeValue() {
        return this.value;
    }

    public final String toString() {
        return "" + this.value;
    }

    @Override
    public final CompleteProc valueAt(int index) {
        throw new IndexOutOfBoundsException(Integer.toString(index));
    }
}

