/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.klvm;

import java.util.HashSet;
import java.util.Set;
import org.torqlang.klvm.AbstractInstr;
import org.torqlang.klvm.CompleteOrIdent;
import org.torqlang.klvm.Env;
import org.torqlang.klvm.Ident;
import org.torqlang.klvm.Instr;
import org.torqlang.klvm.KernelVisitor;
import org.torqlang.klvm.Machine;
import org.torqlang.klvm.Ptn;
import org.torqlang.klvm.Value;
import org.torqlang.klvm.ValueOrPtn;
import org.torqlang.klvm.ValueOrResolvedPtn;
import org.torqlang.klvm.WaitException;
import org.torqlang.util.SourceSpan;

public class CaseElseInstr
extends AbstractInstr {
    public final CompleteOrIdent x;
    public final ValueOrPtn valueOrPtn;
    public final Instr consequent;
    public final Instr alternate;

    public CaseElseInstr(CompleteOrIdent x, ValueOrPtn valueOrPtn, Instr consequent, Instr alternate, SourceSpan sourceSpan) {
        super(sourceSpan);
        this.x = x;
        this.valueOrPtn = valueOrPtn;
        this.consequent = consequent;
        this.alternate = alternate;
    }

    @Override
    public final <T, R> R accept(KernelVisitor<T, R> visitor, T state) {
        return visitor.visitCaseElseInstr(this, state);
    }

    @Override
    public final void captureLexicallyFree(Set<Ident> knownBound, Set<Ident> lexicallyFree) {
        CompleteOrIdent.captureLexicallyFree(this.x, knownBound, lexicallyFree);
        HashSet<Ident> knownBoundCopy = new HashSet<Ident>(knownBound);
        ValueOrPtn valueOrPtn = this.valueOrPtn;
        if (valueOrPtn instanceof Ptn) {
            Ptn ptn = (Ptn)valueOrPtn;
            ptn.captureLexicallyFree(knownBoundCopy, lexicallyFree);
        }
        this.consequent.captureLexicallyFree(knownBoundCopy, lexicallyFree);
        this.alternate.captureLexicallyFree(knownBound, lexicallyFree);
    }

    @Override
    public final void compute(Env env, Machine machine) throws WaitException {
        Value xRes = this.x.resolveValue(env);
        ValueOrResolvedPtn valueOrResolvedPtn = xRes.caseOf(this.valueOrPtn, env);
        if (valueOrResolvedPtn != null) {
            Env ptnEnv = xRes.deconstruct(valueOrResolvedPtn, env);
            machine.pushStackEntry(this.consequent, ptnEnv);
        } else {
            machine.pushStackEntry(this.alternate, env);
        }
    }
}

