/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.klvm;

import java.util.Set;
import org.torqlang.klvm.AbstractInstr;
import org.torqlang.klvm.CompleteOrIdent;
import org.torqlang.klvm.Env;
import org.torqlang.klvm.Ident;
import org.torqlang.klvm.Instr;
import org.torqlang.klvm.KernelVisitor;
import org.torqlang.klvm.Machine;
import org.torqlang.klvm.Ptn;
import org.torqlang.klvm.Value;
import org.torqlang.klvm.ValueOrPtn;
import org.torqlang.klvm.ValueOrResolvedPtn;
import org.torqlang.klvm.WaitException;
import org.torqlang.util.SourceSpan;

public final class CaseInstr
extends AbstractInstr {
    public final CompleteOrIdent x;
    public final ValueOrPtn valueOrPtn;
    public final Instr consequent;

    public CaseInstr(CompleteOrIdent x, ValueOrPtn valueOrPtn, Instr consequent, SourceSpan sourceSpan) {
        super(sourceSpan);
        this.x = x;
        this.valueOrPtn = valueOrPtn;
        this.consequent = consequent;
    }

    @Override
    public final <T, R> R accept(KernelVisitor<T, R> visitor, T state) {
        return visitor.visitCaseInstr(this, state);
    }

    @Override
    public final void captureLexicallyFree(Set<Ident> knownBound, Set<Ident> lexicallyFree) {
        CompleteOrIdent.captureLexicallyFree(this.x, knownBound, lexicallyFree);
        ValueOrPtn valueOrPtn = this.valueOrPtn;
        if (valueOrPtn instanceof Ptn) {
            Ptn ptn = (Ptn)valueOrPtn;
            ptn.captureLexicallyFree(knownBound, lexicallyFree);
        }
        this.consequent.captureLexicallyFree(knownBound, lexicallyFree);
    }

    @Override
    public final void compute(Env env, Machine machine) throws WaitException {
        Value xRes = this.x.resolveValue(env);
        ValueOrResolvedPtn valueOrResolvedPtn = xRes.caseOf(this.valueOrPtn, env);
        if (valueOrResolvedPtn != null) {
            Env ptnEnv = xRes.deconstruct(valueOrResolvedPtn, env);
            machine.pushStackEntry(this.consequent, ptnEnv);
        }
    }
}

