/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.klvm;

import java.util.List;
import org.torqlang.klvm.CommonFeatures;
import org.torqlang.klvm.CompleteOrIdent;
import org.torqlang.klvm.CompleteRec;
import org.torqlang.klvm.Env;
import org.torqlang.klvm.Feature;
import org.torqlang.klvm.Ident;
import org.torqlang.klvm.InvalidArgCountError;
import org.torqlang.klvm.KernelModule;
import org.torqlang.klvm.Literal;
import org.torqlang.klvm.Machine;
import org.torqlang.klvm.Null;
import org.torqlang.klvm.PartialField;
import org.torqlang.klvm.PartialObj;
import org.torqlang.klvm.PartialObjProcTable;
import org.torqlang.klvm.Proc;
import org.torqlang.klvm.Rec;
import org.torqlang.klvm.Str;
import org.torqlang.klvm.ValueOrVar;
import org.torqlang.klvm.WaitException;

public final class CellMod
implements KernelModule {
    public static final Str CELL_STR = Str.of("Cell");
    public static final Ident CELL_IDENT = Ident.create(CellMod.CELL_STR.value);
    private final CompleteRec namesake = Rec.completeRecBuilder().addField(CommonFeatures.$NEW, CellMod::clsNew).build();
    private final CompleteRec exports = Rec.completeRecBuilder().addField(CELL_STR, this.namesake).build();

    private CellMod() {
    }

    public static CellMod singleton() {
        return LazySingleton.SINGLETON;
    }

    static void clsNew(List<CompleteOrIdent> ys, Env env, Machine machine) throws WaitException {
        int expectedArgCount = 2;
        if (ys.size() != 2) {
            throw new InvalidArgCountError(2, ys, "Cell.new");
        }
        ValueOrVar initial = ys.get(0).resolveValueOrVar(env);
        CellObj cellObj = new CellObj(initial);
        ValueOrVar target = ys.get(1).resolveValueOrVar(env);
        target.bindToValue(cellObj, null);
    }

    @Override
    public final CompleteRec exports() {
        return this.exports;
    }

    @Override
    public final CompleteRec namesake() {
        return this.namesake;
    }

    @Override
    public final Ident namesakeIdent() {
        return CELL_IDENT;
    }

    private static final class LazySingleton {
        private static final CellMod SINGLETON = new CellMod();

        private LazySingleton() {
        }
    }

    static final class CellObj
    implements PartialObj {
        private static final PartialObjProcTable<CellObj> objProcTable = PartialObjProcTable.builder().build();
        private ValueOrVar valueOrVar;

        CellObj(ValueOrVar valueOrVar) {
            this.valueOrVar = valueOrVar;
        }

        @Override
        public final Feature featureAt(int index) {
            return objProcTable.featureAt(index);
        }

        @Override
        public final PartialField fieldAt(int index) {
            return objProcTable.fieldAt(index);
        }

        @Override
        public final int fieldCount() {
            return objProcTable.fieldCount();
        }

        final ValueOrVar get() {
            return this.valueOrVar;
        }

        @Override
        public final boolean isValidKey() {
            return true;
        }

        @Override
        public final Literal label() {
            return Null.SINGLETON;
        }

        @Override
        public final ValueOrVar select(Feature feature) {
            return objProcTable.selectAndBind(this, feature);
        }

        final ValueOrVar set(ValueOrVar valueOrVar) {
            ValueOrVar previous = this.valueOrVar;
            this.valueOrVar = valueOrVar;
            return previous;
        }

        public final String toString() {
            return this.toKernelString();
        }

        @Override
        public final Proc valueAt(int index) {
            return objProcTable.valueAt(this, index);
        }
    }
}

