/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.klvm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.torqlang.klvm.CompleteField;
import org.torqlang.klvm.CompleteObj;
import org.torqlang.klvm.CompleteObjProc;
import org.torqlang.klvm.CompleteObjProcBinding;
import org.torqlang.klvm.CompleteProc;
import org.torqlang.klvm.Composite;
import org.torqlang.klvm.Feature;
import org.torqlang.klvm.FeatureComparator;
import org.torqlang.klvm.FeatureNotFoundError;
import org.torqlang.klvm.ObjProcTable;
import org.torqlang.util.BinarySearchTools;

public final class CompleteObjProcTable<T extends CompleteObj>
implements ObjProcTable<T> {
    private final Entry<T>[] entries;

    private CompleteObjProcTable(List<Entry<T>> entries) {
        this.entries = entries.toArray(new Entry[0]);
        Arrays.sort(this.entries, (a, b) -> FeatureComparator.SINGLETON.compare(a.feature, b.feature));
    }

    public static <T extends CompleteObj> Builder<T> builder() {
        return new Builder();
    }

    @Override
    public final Feature featureAt(int index) {
        return this.entries[index].feature;
    }

    @Override
    public final CompleteField fieldAt(int index) {
        Entry<T> entry = this.entries[index];
        return new CompleteField(entry.feature, (CompleteProc)((Object)entry.objProc));
    }

    @Override
    public final int fieldCount() {
        return this.entries.length;
    }

    @Override
    public final CompleteObjProcBinding<T> selectAndBind(T target, Feature selector) {
        int index = BinarySearchTools.search((Object[])this.entries, e -> FeatureComparator.SINGLETON.compare(selector, e.feature));
        if (index < 0) {
            throw new FeatureNotFoundError((Composite)target, selector);
        }
        return new CompleteObjProcBinding<T>(target, this.entries[index].objProc);
    }

    @Override
    public final CompleteProc valueAt(T target, int index) {
        Feature feature = this.entries[index].feature;
        return this.selectAndBind(target, feature);
    }

    private record Entry<T extends CompleteObj>(Feature feature, CompleteObjProc<T> objProc) {
    }

    public static class Builder<T extends CompleteObj> {
        private final List<Entry<T>> entries = new ArrayList<Entry<T>>();

        private Builder() {
        }

        public Builder<T> addEntry(Feature feature, CompleteObjProc<T> objProc) {
            this.entries.add(new Entry<T>(feature, objProc));
            return this;
        }

        public CompleteObjProcTable<T> build() {
            return new CompleteObjProcTable<T>(this.entries);
        }
    }
}

