/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.klvm;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.torqlang.klvm.BasicCompleteRec;
import org.torqlang.klvm.Complete;
import org.torqlang.klvm.CompleteField;
import org.torqlang.klvm.Feature;
import org.torqlang.klvm.Literal;
import org.torqlang.klvm.Rec;
import org.torqlang.klvm.Value;
import org.torqlang.klvm.WaitException;

public interface CompleteRec
extends Complete,
Rec {
    public static CompleteRec create(List<CompleteField> completeFields) {
        return BasicCompleteRec.createPrivatelyForKlvm(null, completeFields);
    }

    public static CompleteRec create(Literal label, List<CompleteField> completeFields) {
        return BasicCompleteRec.createPrivatelyForKlvm(label, completeFields);
    }

    public static CompleteRec singleton(Feature feature, Complete value) {
        return BasicCompleteRec.createPrivatelyForKlvm(null, List.of(new CompleteField(feature, value)));
    }

    default public boolean equalsComplete(Object other) {
        if (!(other instanceof Complete)) {
            return false;
        }
        Complete complete = (Complete)other;
        try {
            return this.entails(complete, null);
        }
        catch (WaitException exc) {
            throw new IllegalStateException("Unexpected WaitException processing Complete value");
        }
    }

    @Override
    public CompleteField fieldAt(int var1);

    @Override
    public Complete findValue(Feature var1);

    default public int hashCodeComplete(IdentityHashMap<CompleteRec, Object> memos) {
        if (memos != null) {
            if (memos.containsKey(this)) {
                throw new IllegalArgumentException("Circular reference error");
            }
        } else {
            memos = new IdentityHashMap();
        }
        memos.put(this, Value.PRESENT);
        int hash = 17;
        for (int i = 0; i < this.fieldCount(); ++i) {
            CompleteField f = this.fieldAt(i);
            Complete complete = f.value;
            if (complete instanceof CompleteRec) {
                CompleteRec completeRec = (CompleteRec)complete;
                hash = memos.containsKey(this) ? 31 * hash + 11 : 31 * hash + completeRec.hashCodeComplete(memos);
            } else {
                hash = 31 * hash + f.value.hashCode();
            }
            hash = 31 * hash + f.feature.hashCode();
        }
        return hash;
    }

    @Override
    public Complete select(Feature var1);

    @Override
    default public Object toNativeValue() {
        return this.toNativeValue(null);
    }

    default public Object toNativeValue(IdentityHashMap<CompleteRec, Object> memos) {
        if (memos != null) {
            if (memos.containsKey(this)) {
                throw new IllegalArgumentException("Circular reference error");
            }
        } else {
            memos = new IdentityHashMap();
        }
        memos.put(this, Value.PRESENT);
        HashMap<Object, Object> fields = new HashMap<Object, Object>(this.fieldCount());
        for (int i = 0; i < this.fieldCount(); ++i) {
            Object v;
            CompleteField f = this.fieldAt(i);
            Object k = f.feature.toNativeValue();
            Complete complete = f.value;
            if (complete instanceof CompleteRec) {
                CompleteRec completeRec = (CompleteRec)complete;
                v = completeRec.toNativeValue(memos);
            } else {
                v = f.value.toNativeValue();
            }
            fields.put(k, v);
        }
        if (this.label().equals(DEFAULT_LABEL)) {
            return fields;
        }
        return Map.of("$label", this.label().toNativeValue(), "$fields", fields);
    }

    @Override
    public Complete valueAt(int var1);
}

