/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.klvm;

import java.util.ArrayList;
import java.util.List;
import org.torqlang.klvm.BasicCompleteRec;
import org.torqlang.klvm.BasicCompleteTuple;
import org.torqlang.klvm.Complete;
import org.torqlang.klvm.CompleteField;
import org.torqlang.klvm.CompleteRec;
import org.torqlang.klvm.Feature;
import org.torqlang.klvm.FeatureProviderComparator;
import org.torqlang.klvm.Int64;
import org.torqlang.klvm.Literal;

public final class CompleteRecBuilder {
    private final List<CompleteField> fields;
    private Literal label;

    CompleteRecBuilder() {
        this.fields = new ArrayList<CompleteField>();
    }

    CompleteRecBuilder(Literal label, List<CompleteField> fields) {
        this.label = label;
        this.fields = new ArrayList<CompleteField>(fields);
    }

    public final CompleteRecBuilder addAllFields(CompleteRec rec) {
        for (int i = 0; i < rec.fieldCount(); ++i) {
            CompleteField field = rec.fieldAt(i);
            this.addField(field);
        }
        return this;
    }

    public final CompleteRecBuilder addField(CompleteField field) {
        this.fields.add(field);
        return this;
    }

    public final CompleteRecBuilder addField(Feature feature, Complete value) {
        this.addField(new CompleteField(feature, value));
        return this;
    }

    public final CompleteRec build() {
        Int64 lastInt;
        if (this.fields.isEmpty()) {
            return BasicCompleteTuple.createPrivatelyForKlvm(this.label, new Complete[0]);
        }
        this.fields.sort(FeatureProviderComparator.comparator());
        Feature lastFeature = this.fields.get((int)(this.fields.size() - 1)).feature;
        if (lastFeature instanceof Int64 && (lastInt = (Int64)lastFeature).longValue() == (long)(this.fields.size() - 1)) {
            Complete[] values = new Complete[this.fields.size()];
            for (int i = 0; i < this.fields.size(); ++i) {
                values[i] = this.fields.get((int)i).value;
            }
            return BasicCompleteTuple.createPrivatelyForKlvm(this.label, values);
        }
        return BasicCompleteRec.createPrivatelyForKlvm(this.label, this.fields);
    }

    public final CompleteRecBuilder setLabel(Literal label) {
        this.label = label;
        return this;
    }
}

