/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.klvm;

import java.util.List;
import java.util.Set;
import org.torqlang.klvm.AbstractInstr;
import org.torqlang.klvm.BasicCompleteTuple;
import org.torqlang.klvm.BasicPartialTuple;
import org.torqlang.klvm.Complete;
import org.torqlang.klvm.CreateInstr;
import org.torqlang.klvm.Env;
import org.torqlang.klvm.Ident;
import org.torqlang.klvm.KernelVisitor;
import org.torqlang.klvm.Literal;
import org.torqlang.klvm.LiteralOrVar;
import org.torqlang.klvm.Machine;
import org.torqlang.klvm.Tuple;
import org.torqlang.klvm.TupleDef;
import org.torqlang.klvm.ValueDef;
import org.torqlang.klvm.ValueOrVar;
import org.torqlang.klvm.WaitException;
import org.torqlang.util.SourceSpan;

public final class CreateTupleInstr
extends AbstractInstr
implements CreateInstr {
    public final Ident x;
    public final TupleDef tupleDef;

    public CreateTupleInstr(Ident x, TupleDef tupleDef, SourceSpan sourceSpan) {
        super(sourceSpan);
        this.x = x;
        this.tupleDef = tupleDef;
    }

    @Override
    public final <T, R> R accept(KernelVisitor<T, R> visitor, T state) {
        return visitor.visitCreateTupleInstr(this, state);
    }

    @Override
    public final void captureLexicallyFree(Set<Ident> knownBound, Set<Ident> lexicallyFree) {
        Ident.captureLexicallyFree(this.x, knownBound, lexicallyFree);
        this.tupleDef.captureLexicallyFree(knownBound, lexicallyFree);
    }

    @Override
    public final void compute(Env env, Machine machine) throws WaitException {
        LiteralOrVar labelRes = (LiteralOrVar)this.tupleDef.label.resolveValueOrVar(env);
        boolean isComplete = labelRes instanceof Literal;
        List<ValueDef> valueDefs = this.tupleDef.valueDefs;
        int size = valueDefs.size();
        ValueOrVar[] partialValues = new ValueOrVar[size];
        Complete[] completeValues = new Complete[size];
        for (int i = 0; i < size; ++i) {
            ValueDef td = valueDefs.get(i);
            ValueOrVar valueOrVar = td.value.resolveValueOrVar(env);
            if (valueOrVar instanceof Complete) {
                Complete complete;
                completeValues[i] = complete = (Complete)valueOrVar;
            } else {
                isComplete = false;
            }
            partialValues[i] = valueOrVar;
        }
        Tuple tuple = isComplete ? BasicCompleteTuple.createPrivatelyForKlvm((Literal)labelRes, completeValues) : BasicPartialTuple.createPrivatelyForKlvm(labelRes, partialValues);
        ValueOrVar xRes = this.x.resolveValueOrVar(env);
        xRes.bindToValue(tuple, null);
    }
}

