/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.klvm;

import java.util.Set;
import org.torqlang.klvm.AbstractInstr;
import org.torqlang.klvm.DebugInstrListener;
import org.torqlang.klvm.Env;
import org.torqlang.klvm.Ident;
import org.torqlang.klvm.Instr;
import org.torqlang.klvm.KernelVisitor;
import org.torqlang.klvm.Machine;
import org.torqlang.klvm.Stack;
import org.torqlang.klvm.WaitException;
import org.torqlang.util.SourceSpan;

public final class DebugInstr
extends AbstractInstr {
    private final DebugInstrListener listener;
    private Instr nextInstr;
    private Env nextEnv;

    public DebugInstr(DebugInstrListener listener, Instr nextInstr, Env nextEnv, SourceSpan sourceSpan) {
        super(sourceSpan);
        this.nextInstr = nextInstr;
        this.nextEnv = nextEnv;
        this.listener = listener;
    }

    @Override
    public final <T, R> R accept(KernelVisitor<T, R> visitor, T state) {
        return visitor.visitDebugInstr(this, state);
    }

    @Override
    public final void captureLexicallyFree(Set<Ident> knownBound, Set<Ident> lexicallyFree) {
        this.nextInstr.captureLexicallyFree(knownBound, lexicallyFree);
    }

    @Override
    public final void compute(Env env, Machine machine) throws WaitException {
        if (this.listener != null) {
            this.listener.onNextInstr(this.nextInstr, this.nextEnv, machine);
        }
        this.nextInstr.compute(this.nextEnv, machine);
        Stack next = machine.popStackEntry();
        if (next != null) {
            this.nextInstr = next.instr;
            this.nextEnv = next.env;
            machine.pushStackEntry(this, Env.emptyEnv());
        }
    }

    public final Env nextEnv() {
        return this.nextEnv;
    }

    public final Instr nextInstr() {
        return this.nextInstr;
    }
}

