/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.klvm;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.torqlang.klvm.Complete;
import org.torqlang.klvm.DuplicateIdentError;
import org.torqlang.klvm.EnvEntry;
import org.torqlang.klvm.Ident;
import org.torqlang.klvm.Kernel;
import org.torqlang.klvm.KernelVisitor;
import org.torqlang.klvm.Var;

public interface Env
extends Kernel,
Iterable<EnvEntry> {
    public static Env create(Env parentEnv, List<EnvEntry> bindings) {
        if (parentEnv == ArrayEnv.EMPTY_ENV) {
            parentEnv = null;
        }
        if (bindings.isEmpty()) {
            return parentEnv == null ? ArrayEnv.EMPTY_ENV : parentEnv;
        }
        return new ArrayEnv(parentEnv, bindings);
    }

    public static Env create(Env parentEnv, Map<Ident, Var> bindings) {
        if (parentEnv == ArrayEnv.EMPTY_ENV) {
            parentEnv = null;
        }
        if (bindings.isEmpty()) {
            return parentEnv == null ? ArrayEnv.EMPTY_ENV : parentEnv;
        }
        return new ArrayEnv(parentEnv, bindings);
    }

    public static Env create(Env parentEnv, EnvEntry e1) {
        if (e1 == null) {
            throw new NullPointerException();
        }
        return new ArrayEnv(parentEnv, new EnvEntry[]{e1});
    }

    public static Env create(Env parentEnv, EnvEntry e1, EnvEntry e2) {
        if (e1 == null || e2 == null) {
            throw new NullPointerException();
        }
        return new ArrayEnv(parentEnv, new EnvEntry[]{e1, e2});
    }

    public static Env create(Env parentEnv, EnvEntry e1, EnvEntry e2, EnvEntry e3) {
        if (e1 == null || e2 == null || e3 == null) {
            throw new NullPointerException();
        }
        return new ArrayEnv(parentEnv, new EnvEntry[]{e1, e2, e3});
    }

    public static Env create(List<EnvEntry> bindings) {
        if (bindings.isEmpty()) {
            return ArrayEnv.EMPTY_ENV;
        }
        return new ArrayEnv(null, bindings);
    }

    public static Env create(Map<Ident, Var> bindings) {
        return bindings.isEmpty() ? ArrayEnv.EMPTY_ENV : new ArrayEnv(null, bindings);
    }

    public static Env create(EnvEntry e1) {
        if (e1 == null) {
            throw new NullPointerException();
        }
        return new ArrayEnv(null, new EnvEntry[]{e1});
    }

    public static Env create(EnvEntry e1, EnvEntry e2) {
        if (e1 == null || e2 == null) {
            throw new NullPointerException();
        }
        return new ArrayEnv(null, new EnvEntry[]{e1, e2});
    }

    public static Env createComplete(Map<Ident, Complete> bindings) {
        EnvEntry[] completeEntries = new EnvEntry[bindings.size()];
        int i = 0;
        for (Map.Entry<Ident, Complete> e : bindings.entrySet()) {
            completeEntries[i++] = new EnvEntry(e.getKey(), new Var(e.getValue()));
        }
        return new ArrayEnv(ArrayEnv.EMPTY_ENV, completeEntries);
    }

    public static Env createPrivatelyForKlvm(Env parentEnv, EnvEntry[] bindings) {
        return new ArrayEnv(parentEnv, bindings);
    }

    public static Env emptyEnv() {
        return ArrayEnv.EMPTY_ENV;
    }

    public Env add(EnvEntry var1);

    public Set<Ident> collectIdents(Var var1);

    public void collectIdents(Var var1, Set<Ident> var2);

    public boolean contains(Ident var1);

    public String formatValue();

    public Var get(Ident var1);

    public Env parentEnv();

    public Env rootEnv();

    public Env setRootEnv(Env var1);

    public EnvEntry shallowEntryAt(int var1);

    public int shallowSize();

    public static class ArrayEnv
    implements Env {
        private static final Env EMPTY_ENV = new ArrayEnv();
        private final Env parentEnv;
        private final EnvEntry[] bindings;

        private ArrayEnv() {
            this.parentEnv = null;
            this.bindings = new EnvEntry[0];
        }

        private ArrayEnv(Env parentEnv, EnvEntry[] bindings) {
            this.parentEnv = parentEnv;
            this.bindings = bindings;
        }

        private ArrayEnv(Env parentEnv, Map<Ident, Var> bindings) {
            this(parentEnv, ArrayEnv.makeBindingsArray(bindings));
        }

        private ArrayEnv(Env parentEnv, List<EnvEntry> bindings) {
            this(parentEnv, ArrayEnv.makeBindingsArray(bindings));
        }

        private static EnvEntry[] makeBindingsArray(List<EnvEntry> bindings) {
            EnvEntry[] answer = new EnvEntry[bindings.size()];
            for (int i = 0; i < bindings.size(); ++i) {
                answer[i] = bindings.get(i);
            }
            return answer;
        }

        private static EnvEntry[] makeBindingsArray(Map<Ident, Var> bindings) {
            EnvEntry[] answer = new EnvEntry[bindings.size()];
            int i = 0;
            for (Map.Entry<Ident, Var> e : bindings.entrySet()) {
                answer[i++] = new EnvEntry(e.getKey(), e.getValue());
            }
            return answer;
        }

        @Override
        public final <T, R> R accept(KernelVisitor<T, R> visitor, T state) {
            return visitor.visitEnv(this, state);
        }

        @Override
        public final Env add(EnvEntry entry) {
            for (EnvEntry e : this.bindings) {
                if (!entry.ident.equals(e.ident)) continue;
                throw new DuplicateIdentError(entry.ident);
            }
            EnvEntry[] newBindings = new EnvEntry[this.bindings.length + 1];
            System.arraycopy(this.bindings, 0, newBindings, 0, this.bindings.length);
            newBindings[this.bindings.length] = entry;
            return new ArrayEnv(this.parentEnv, newBindings);
        }

        @Override
        public final void collectIdents(Var var, Set<Ident> collector) {
            for (EnvEntry envEntry : this.bindings) {
                if (!envEntry.var.equals(var)) continue;
                collector.add(envEntry.ident);
            }
            if (this.parentEnv != null) {
                this.parentEnv.collectIdents(var, collector);
            }
        }

        @Override
        public final Set<Ident> collectIdents(Var var) {
            HashSet<Ident> collector = new HashSet<Ident>();
            this.collectIdents(var, collector);
            return collector;
        }

        @Override
        public final boolean contains(Ident ident) {
            for (EnvEntry envEntry : this.bindings) {
                if (!envEntry.ident.equals(ident)) continue;
                return true;
            }
            return this.parentEnv != null && this.parentEnv.contains(ident);
        }

        @Override
        public final String formatValue() {
            StringBuilder sb = new StringBuilder();
            int scope = 0;
            Env currentEnv = this;
            while (currentEnv != null) {
                for (int i = 0; i < currentEnv.shallowSize(); ++i) {
                    EnvEntry entry = currentEnv.shallowEntryAt(i);
                    sb.append("env[");
                    sb.append(scope);
                    sb.append("]: ");
                    sb.append(entry.ident);
                    sb.append(" = ");
                    sb.append(entry.var);
                    if (i + 1 >= currentEnv.shallowSize()) continue;
                    sb.append('\n');
                }
                ++scope;
                if ((currentEnv = currentEnv.parentEnv()) == null) continue;
                sb.append('\n');
            }
            return sb.toString();
        }

        @Override
        public final Var get(Ident ident) {
            for (EnvEntry envEntry : this.bindings) {
                if (!envEntry.ident.equals(ident)) continue;
                return envEntry.var;
            }
            return this.parentEnv == null ? null : this.parentEnv.get(ident);
        }

        @Override
        public final Iterator<EnvEntry> iterator() {
            return new ArrayEnvIterator();
        }

        @Override
        public final Env parentEnv() {
            return this.parentEnv;
        }

        @Override
        public final Env rootEnv() {
            return this.parentEnv == null ? this : this.parentEnv.rootEnv();
        }

        @Override
        public final Env setRootEnv(Env rootEnv) {
            if (this.parentEnv == null) {
                return new ArrayEnv(rootEnv, this.bindings);
            }
            return new ArrayEnv(this.parentEnv.setRootEnv(rootEnv), this.bindings);
        }

        @Override
        public final EnvEntry shallowEntryAt(int index) {
            return this.bindings[index];
        }

        @Override
        public final int shallowSize() {
            return this.bindings.length;
        }

        public final String toString() {
            return this.formatValue();
        }

        private class ArrayEnvIterator
        implements Iterator<EnvEntry> {
            private int next;

            private ArrayEnvIterator() {
            }

            @Override
            public final boolean hasNext() {
                return this.next < ArrayEnv.this.bindings.length;
            }

            @Override
            public final EnvEntry next() {
                if (this.next >= ArrayEnv.this.bindings.length) {
                    throw new NoSuchElementException("Next element is not present");
                }
                return ArrayEnv.this.bindings[this.next++];
            }
        }
    }
}

