/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.klvm;

import java.util.Objects;
import java.util.Set;
import org.torqlang.klvm.Bool;
import org.torqlang.klvm.Complete;
import org.torqlang.klvm.Env;
import org.torqlang.klvm.FailedValueError;
import org.torqlang.klvm.Instr;
import org.torqlang.klvm.KernelVisitor;
import org.torqlang.klvm.Memo;
import org.torqlang.klvm.Rec;
import org.torqlang.klvm.Stack;
import org.torqlang.klvm.Str;
import org.torqlang.klvm.Value;
import org.torqlang.klvm.ValueOrIdent;
import org.torqlang.klvm.ValueOrPtn;
import org.torqlang.klvm.ValueOrResolvedPtn;
import org.torqlang.klvm.ValueOrVar;
import org.torqlang.klvm.Var;
import org.torqlang.util.GetStackTrace;
import org.torqlang.util.IndentLines;

public final class FailedValue
implements Value,
Complete {
    private static final String CAUSED_BY_COLON = "Caused by:";
    private static final String FAILED_VALUE_ERROR_COLON = "FailedValue error:";
    private static final String INDENT = "    ";
    private final String owner;
    private final long threadId;
    private final String threadName;
    private final Complete error;
    private final Stack stack;
    private final FailedValue torqCause;
    private final Throwable nativeCause;

    public FailedValue(String owner, Complete error, Stack stack, FailedValue torqCause, Throwable nativeCause) {
        this.owner = owner;
        this.threadId = Thread.currentThread().getId();
        this.threadName = Thread.currentThread().getName();
        this.error = error;
        this.stack = stack;
        this.torqCause = torqCause;
        this.nativeCause = nativeCause;
    }

    public static FailedValue create(String owner, Throwable throwable) {
        return FailedValue.create(owner, null, throwable);
    }

    public static FailedValue create(String owner, Stack stack, Throwable throwable) {
        Str error;
        String n = throwable.getClass().getName();
        Object m = throwable.getMessage();
        if (m == null) {
            error = Str.of(n);
        } else {
            int maxErrorLen = 100;
            if (((String)m).length() > maxErrorLen) {
                m = ((String)m).substring(0, maxErrorLen) + "...";
            }
            error = Str.of(n + ": " + (String)m);
        }
        return new FailedValue(owner, error, stack, null, throwable);
    }

    public static String formatDetailsString(String heading, String owner, long threadId, String threadName, Complete error, Stack current, Throwable nativeCause) {
        StringBuilder sb = new StringBuilder();
        FailedValue.formatDetailsString(heading, owner, threadId, threadName, error, current, nativeCause, sb);
        return sb.toString();
    }

    public static void formatDetailsString(String heading, String owner, long threadId, String threadName, Complete error, Stack current, Throwable nativeCause, StringBuilder sb) {
        sb.append(heading);
        sb.append('\n');
        sb.append("    Owner: ").append(owner);
        sb.append('\n');
        sb.append("    Thread id: ").append(threadId);
        sb.append('\n');
        sb.append("    Thread name: ").append(threadName);
        sb.append('\n');
        sb.append("    Error: ").append(error);
        if (current != null) {
            sb.append('\n');
            sb.append("    Source context: ");
            sb.append('\n');
            Instr sourceSpan = current.instr;
            String inlineMessage = error != null ? Objects.toString(error) : Objects.toString(nativeCause);
            String formatted = sourceSpan.formatSource(inlineMessage, 5, 4, 5);
            sb.append(IndentLines.apply((String)formatted, (int)(INDENT.length() * 2)));
        }
        if (nativeCause != null) {
            sb.append('\n');
            sb.append("    Native cause with stack trace: ");
            sb.append('\n');
            String stackTrace = GetStackTrace.apply((Throwable)nativeCause, (boolean)true);
            sb.append(IndentLines.apply((String)stackTrace, (int)(INDENT.length() * 2)));
        }
    }

    @Override
    public final <T, R> R accept(KernelVisitor<T, R> visitor, T state) {
        return visitor.visitFailedValue(this, state);
    }

    @Override
    public Value add(Value addend) {
        throw new FailedValueError(this);
    }

    @Override
    public final Value bindToValue(Value value, Set<Memo> memos) {
        throw new FailedValueError(this);
    }

    @Override
    public final Value bindToValueOrVar(ValueOrVar valueOrVar, Set<Memo> memos) {
        throw new FailedValueError(this);
    }

    @Override
    public final Value bindToVar(Var var, Set<Memo> memos) {
        throw new FailedValueError(this);
    }

    @Override
    public final ValueOrResolvedPtn caseNonRecOfThis(Value nonRecValue, Env env) {
        throw new FailedValueError(this);
    }

    @Override
    public final ValueOrResolvedPtn caseOf(ValueOrPtn valueOrPtn, Env env) {
        throw new FailedValueError(this);
    }

    @Override
    public final ValueOrResolvedPtn caseRecOfThis(Rec rec, Env env) {
        throw new FailedValueError(this);
    }

    @Override
    public final Value checkNotFailedValue() {
        throw new FailedValueError(this);
    }

    @Override
    public final Env deconstruct(ValueOrResolvedPtn valueOrResolvedPtn, Env env) {
        throw new FailedValueError(this);
    }

    @Override
    public final Bool disentails(Value operand) {
        throw new FailedValueError(this);
    }

    @Override
    public final Value divide(Value divisor) {
        throw new FailedValueError(this);
    }

    @Override
    public final Bool entails(Value operand) {
        throw new FailedValueError(this);
    }

    @Override
    public final boolean entails(Value operand, Set<Memo> memos) {
        throw new FailedValueError(this);
    }

    @Override
    public final boolean entailsRec(Rec operand, Set<Memo> memos) {
        throw new FailedValueError(this);
    }

    @Override
    public final boolean entailsValueOrIdent(ValueOrIdent operand, Env env) {
        throw new FailedValueError(this);
    }

    @Override
    public final boolean entailsValueOrVar(ValueOrVar operand, Set<Memo> memos) {
        throw new FailedValueError(this);
    }

    @Override
    public final boolean entailsVar(Var operand, Set<Memo> memos) {
        throw new FailedValueError(this);
    }

    public final Complete error() {
        return this.error;
    }

    @Override
    public final Bool greaterThan(Value operand) {
        throw new FailedValueError(this);
    }

    @Override
    public final Bool greaterThanOrEqualTo(Value operand) {
        throw new FailedValueError(this);
    }

    @Override
    public final Bool lessThan(Value operand) {
        throw new FailedValueError(this);
    }

    @Override
    public final Bool lessThanOrEqualTo(Value operand) {
        throw new FailedValueError(this);
    }

    @Override
    public final Value modulo(Value divisor) {
        throw new FailedValueError(this);
    }

    @Override
    public final Value multiply(Value multiplicand) {
        throw new FailedValueError(this);
    }

    public final Throwable nativeCause() {
        return this.nativeCause;
    }

    @Override
    public final Value negate() {
        throw new FailedValueError(this);
    }

    @Override
    public final Value not() {
        throw new FailedValueError(this);
    }

    @Override
    public final Value resolveValue(Env env) {
        throw new FailedValueError(this);
    }

    @Override
    public final Value resolveValue() {
        throw new FailedValueError(this);
    }

    @Override
    public final ValueOrIdent resolveValueOrIdent(Env env) {
        throw new FailedValueError(this);
    }

    @Override
    public final ValueOrVar resolveValueOrVar(Env env) {
        throw new FailedValueError(this);
    }

    @Override
    public final ValueOrVar resolveValueOrVar() {
        throw new FailedValueError(this);
    }

    public final Stack stack() {
        return this.stack;
    }

    @Override
    public final Value subtract(Value subtrahend) {
        throw new FailedValueError(this);
    }

    public final long threadId() {
        return this.threadId;
    }

    public final String threadName() {
        return this.threadName;
    }

    public final String toDetailsString() {
        StringBuilder sb = new StringBuilder();
        this.toDetailsString(FAILED_VALUE_ERROR_COLON, sb);
        return sb.toString();
    }

    private void toDetailsString(String heading, StringBuilder sb) {
        FailedValue.formatDetailsString(heading, this.owner, this.threadId, this.threadName, this.error, this.stack, this.nativeCause, sb);
        if (this.torqCause != null) {
            sb.append('\n');
            this.torqCause.toDetailsString(CAUSED_BY_COLON, sb);
        }
    }

    public final String toString() {
        return this.toKernelString();
    }

    @Override
    public final Rec unifyRecs(Rec rec, Set<Memo> memos) {
        throw new FailedValueError(this);
    }
}

