/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.klvm;

import java.util.Comparator;
import org.torqlang.klvm.Bool;
import org.torqlang.klvm.Eof;
import org.torqlang.klvm.Feature;
import org.torqlang.klvm.Int64;
import org.torqlang.klvm.Null;
import org.torqlang.klvm.Str;
import org.torqlang.klvm.Token;

public final class FeatureComparator
implements Comparator<Feature> {
    public static final FeatureComparator SINGLETON = new FeatureComparator();

    private FeatureComparator() {
    }

    @Override
    public final int compare(Feature f1, Feature f2) {
        if (f1 instanceof Str) {
            int n;
            Str f1s = (Str)f1;
            if (f2 instanceof Str) {
                Str f2s = (Str)f2;
                n = f1s.value.compareTo(f2s.value);
            } else {
                n = -1;
            }
            return n;
        }
        if (f2 instanceof Str) {
            return 1;
        }
        if (f1 instanceof Int64) {
            int n;
            Int64 f1i = (Int64)f1;
            if (f2 instanceof Int64) {
                Int64 f2i = (Int64)f2;
                n = Long.compare(f1i.longValue(), f2i.longValue());
            } else {
                n = -1;
            }
            return n;
        }
        if (f2 instanceof Int64) {
            return 1;
        }
        if (f1 instanceof Bool) {
            int n;
            Bool f1b = (Bool)f1;
            if (f2 instanceof Bool) {
                Bool f2b = (Bool)f2;
                n = Boolean.compare(f1b.value, f2b.value);
            } else {
                n = -1;
            }
            return n;
        }
        if (f2 instanceof Bool) {
            return 1;
        }
        if (f1 == Eof.SINGLETON) {
            return f2 == Eof.SINGLETON ? 0 : -1;
        }
        if (f2 instanceof Eof) {
            return 1;
        }
        if (f1 == Null.SINGLETON) {
            return f2 == Null.SINGLETON ? 0 : -1;
        }
        if (f2 == Null.SINGLETON) {
            return 1;
        }
        Token t1 = (Token)f1;
        Token t2 = (Token)f2;
        return Long.compare(t1.id, t2.id);
    }
}

