/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.klvm;

import java.util.List;
import org.torqlang.klvm.CommonFeatures;
import org.torqlang.klvm.CompleteOrIdent;
import org.torqlang.klvm.CompleteRec;
import org.torqlang.klvm.Env;
import org.torqlang.klvm.FieldIterSource;
import org.torqlang.klvm.Ident;
import org.torqlang.klvm.InvalidArgCountError;
import org.torqlang.klvm.KernelModule;
import org.torqlang.klvm.Machine;
import org.torqlang.klvm.Rec;
import org.torqlang.klvm.Str;
import org.torqlang.klvm.Value;
import org.torqlang.klvm.ValueOrVar;
import org.torqlang.klvm.WaitException;

public final class FieldIterMod
implements KernelModule {
    public static final Str FIELD_ITER_STR = Str.of("FieldIter");
    public static final Ident FIELD_ITER_IDENT = Ident.create(FieldIterMod.FIELD_ITER_STR.value);
    private final CompleteRec namesake = Rec.completeRecBuilder().addField(CommonFeatures.$NEW, FieldIterMod::clsNew).build();
    private final CompleteRec exports = Rec.completeRecBuilder().addField(FIELD_ITER_STR, this.namesake).build();

    private FieldIterMod() {
    }

    public static FieldIterMod singleton() {
        return LazySingleton.SINGLETON;
    }

    static void clsNew(List<CompleteOrIdent> ys, Env env, Machine machine) throws WaitException {
        int expectedArgCount = 2;
        if (ys.size() != 2) {
            throw new InvalidArgCountError(2, ys, "FieldIter.new");
        }
        Value source = ys.get(0).resolveValue(env);
        if (!(source instanceof FieldIterSource)) {
            throw new IllegalArgumentException(String.valueOf(ys.get(0)) + " must be a type of " + FieldIterSource.class.getSimpleName());
        }
        FieldIterSource iterable = (FieldIterSource)((Object)source);
        ValueOrVar iter = iterable.fieldIter();
        ValueOrVar target = ys.get(1).resolveValueOrVar(env);
        target.bindToValueOrVar(iter, null);
    }

    @Override
    public final CompleteRec exports() {
        return this.exports;
    }

    @Override
    public final CompleteRec namesake() {
        return this.namesake;
    }

    @Override
    public final Ident namesakeIdent() {
        return FIELD_ITER_IDENT;
    }

    private static final class LazySingleton {
        private static final FieldIterMod SINGLETON = new FieldIterMod();

        private LazySingleton() {
        }
    }
}

